/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.table;

import com.rapidminer.example.table.AbstractSparseArrayDataRow;

public class ShortSparseArrayDataRow
extends AbstractSparseArrayDataRow {
    private static final long serialVersionUID = 1688504268820756726L;
    private short[] values;

    public ShortSparseArrayDataRow() {
        this(0);
    }

    public ShortSparseArrayDataRow(int size) {
        super(size);
        this.values = new short[size];
    }

    @Override
    protected void swapValues(int a, int b) {
        short tt = this.values[a];
        this.values[a] = this.values[b];
        this.values[b] = tt;
    }

    @Override
    public void resizeValues(int length) {
        short[] d = new short[length];
        System.arraycopy(this.values, 0, d, 0, Math.min(this.values.length, length));
        this.values = d;
    }

    @Override
    public void removeValue(int index) {
        System.arraycopy(this.values, index + 1, this.values, index, this.values.length - (index + 1));
    }

    @Override
    public double getValue(int index) {
        return this.values[index];
    }

    @Override
    public void setValue(int index, double v) {
        this.values[index] = (short)v;
    }

    @Override
    protected double[] getAllValues() {
        double[] result = new double[this.values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.values[i];
        }
        return result;
    }

    @Override
    public int getType() {
        return 11;
    }
}

