/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.table;

import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.regex.Pattern;

public class RapidMinerLineReader {
    private Pattern separatorPattern;
    private String[] commentChars = null;
    private boolean useQuotes = false;
    private char quoteChar = (char)34;
    private char escapeChar = (char)92;
    private boolean trimLines = false;
    private int lineNumber = 1;
    private boolean skipErrorLines;

    public RapidMinerLineReader(String separatorsRegExpr, char[] commentChars, boolean useQuotes, char quoteChar, char escapeChar, boolean trimLines, boolean skipErrorLines) {
        this.separatorPattern = Pattern.compile(separatorsRegExpr);
        if (commentChars != null) {
            this.commentChars = new String[commentChars.length];
            for (int i = 0; i < commentChars.length; ++i) {
                this.commentChars[i] = Character.toString(commentChars[i]);
            }
        }
        this.useQuotes = useQuotes;
        this.quoteChar = quoteChar;
        this.escapeChar = escapeChar;
        this.trimLines = trimLines;
        this.skipErrorLines = skipErrorLines;
    }

    public String[] readLine(BufferedReader in, int expectedNumberOfColumns) throws IOException {
        String line = null;
        while (line == null && (line = in.readLine()) != null) {
            if (this.trimLines) {
                line = line.trim();
            }
            if (this.commentChars != null) {
                for (int c = 0; c < this.commentChars.length; ++c) {
                    if (line.indexOf(this.commentChars[c]) < 0) continue;
                    line = line.substring(0, line.indexOf(this.commentChars[c]));
                }
            }
            if (line.trim().length() != 0) continue;
            line = null;
        }
        if (line == null) {
            return null;
        }
        String[] columns = null;
        columns = this.useQuotes ? Tools.quotedSplit(line, this.separatorPattern, this.quoteChar, this.escapeChar) : this.separatorPattern.split(line, -1);
        if (expectedNumberOfColumns != -1) {
            if (columns.length < expectedNumberOfColumns) {
                if (this.skipErrorLines) {
                    LogService.getGlobal().log("Possible data format error: line " + this.lineNumber + " did not provide the expected number of columns (was: " + columns.length + ", expected: " + expectedNumberOfColumns + "), skip line...", 5);
                    return this.readLine(in, expectedNumberOfColumns);
                }
                throw new IOException("Data format error in line " + this.lineNumber + ": the line does not provide the expected number of columns (was: " + columns.length + ", expected: " + expectedNumberOfColumns + ")! Stop reading...");
            }
            if (columns.length > expectedNumberOfColumns) {
                LogService.getGlobal().log("Possible data format error: line " + this.lineNumber + " did not provide the expected number of columns (was: " + columns.length + ", expected: " + expectedNumberOfColumns + ")!", 5);
            }
        }
        ++this.lineNumber;
        return columns;
    }
}

