/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.table;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AbstractDataRowReader;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.tools.RandomGenerator;

public class RandomDataRowReader
extends AbstractDataRowReader {
    private int size;
    private ExampleSet baseExampleSet;
    private Attribute[] attributes;
    private int counter = 0;

    public RandomDataRowReader(ExampleSet baseExampleSet, Attribute[] attributes, int size) {
        super(new DataRowFactory(0, '.'));
        this.baseExampleSet = baseExampleSet;
        this.attributes = attributes;
        this.size = size;
    }

    @Override
    public boolean hasNext() {
        return this.counter < this.size;
    }

    @Override
    public DataRow next() {
        RandomGenerator random = RandomGenerator.getGlobalRandomGenerator();
        double[] data = new double[this.attributes.length];
        for (int i = 0; i < data.length; ++i) {
            double min = this.baseExampleSet.getStatistics(this.attributes[i], "minimum");
            double max = this.baseExampleSet.getStatistics(this.attributes[i], "maximum");
            data[i] = random.nextDoubleInRange(min, max);
        }
        return new DoubleArrayDataRow(data);
    }
}

