/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.table;

import com.rapidminer.example.MinMaxStatistics;
import com.rapidminer.example.NumericalStatistics;
import com.rapidminer.example.UnknownStatistics;
import com.rapidminer.example.WeightedNumericalStatistics;
import com.rapidminer.example.table.AbstractAttribute;
import com.rapidminer.example.table.NominalMapping;
import com.rapidminer.tools.Tools;

public class NumericalAttribute
extends AbstractAttribute {
    private static final long serialVersionUID = -7425486508057529570L;
    public static final int DEFAULT_NUMBER_OF_DIGITS = -1;
    public static final int UNLIMITED_NUMBER_OF_DIGITS = -2;

    NumericalAttribute(String name) {
        this(name, 2);
    }

    NumericalAttribute(String name, int valueType) {
        super(name, valueType);
        this.registerStatistics(new NumericalStatistics());
        this.registerStatistics(new WeightedNumericalStatistics());
        this.registerStatistics(new MinMaxStatistics());
        this.registerStatistics(new UnknownStatistics());
    }

    private NumericalAttribute(NumericalAttribute a) {
        super(a);
    }

    @Override
    public Object clone() {
        return new NumericalAttribute(this);
    }

    @Override
    public boolean isNominal() {
        return false;
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public NominalMapping getMapping() {
        throw new UnsupportedOperationException("The method getNominalMapping() is not supported by numerical attributes! You probably tried to execute an operator on a numerical data which is only able to handle nominal values. You could use one of the discretization operators before this application.");
    }

    @Override
    public void setMapping(NominalMapping mapping) {
    }

    @Override
    public String getAsString(double value, int numberOfDigits, boolean quoteNominal) {
        if (Double.isNaN(value)) {
            return "?";
        }
        switch (numberOfDigits) {
            case -2: {
                return Double.toString(value);
            }
            case -1: {
                return Tools.formatIntegerIfPossible(value, -1);
            }
        }
        return Tools.formatIntegerIfPossible(value, numberOfDigits);
    }
}

