/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.table;

import com.rapidminer.example.NominalStatistics;
import com.rapidminer.example.UnknownStatistics;
import com.rapidminer.example.table.AbstractAttribute;
import com.rapidminer.tools.Tools;

public abstract class NominalAttribute
extends AbstractAttribute {
    private static final long serialVersionUID = -3830980883541763869L;

    NominalAttribute(String name, int valueType) {
        super(name, valueType);
        this.registerStatistics(new NominalStatistics());
        this.registerStatistics(new UnknownStatistics());
    }

    NominalAttribute(NominalAttribute other) {
        super(other);
    }

    @Override
    public boolean isNominal() {
        return true;
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    @Override
    public String getAsString(double value, int digits, boolean quoteNominal) {
        if (Double.isNaN(value)) {
            return "?";
        }
        try {
            String result = this.getMapping().mapIndex((int)value);
            if (quoteNominal) {
                result = Tools.escape(result);
                result = "\"" + result + "\"";
            }
            return result;
        }
        catch (Throwable e) {
            return "?";
        }
    }
}

