/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.table;

import com.rapidminer.example.table.AbstractSparseArrayDataRow;

public class LongSparseArrayDataRow
extends AbstractSparseArrayDataRow {
    private static final long serialVersionUID = 7128381338958693751L;
    private long[] values;

    public LongSparseArrayDataRow() {
        this(0);
    }

    public LongSparseArrayDataRow(int size) {
        super(size);
        this.values = new long[size];
    }

    @Override
    protected void swapValues(int a, int b) {
        long tt = this.values[a];
        this.values[a] = this.values[b];
        this.values[b] = tt;
    }

    @Override
    public void resizeValues(int length) {
        long[] d = new long[length];
        System.arraycopy(this.values, 0, d, 0, Math.min(this.values.length, length));
        this.values = d;
    }

    @Override
    public void removeValue(int index) {
        System.arraycopy(this.values, index + 1, this.values, index, this.values.length - (index + 1));
    }

    @Override
    public double getValue(int index) {
        return this.values[index];
    }

    @Override
    public void setValue(int index, double v) {
        this.values[index] = (long)v;
    }

    @Override
    protected double[] getAllValues() {
        double[] result = new double[this.values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.values[i];
        }
        return result;
    }

    @Override
    public int getType() {
        return 9;
    }
}

