/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.table;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.table.AbstractExampleTable;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.DataRowReader;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.example.table.NonWritableDataRow;
import com.rapidminer.example.table.ResultSetDataRowReader;
import com.rapidminer.tools.jdbc.DatabaseHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class LimitCachedDatabaseExampleTable
extends AbstractExampleTable {
    private static final long serialVersionUID = -3514641049341063136L;
    private static final int DEFAULT_BATCH_SIZE = 1500;
    private DatabaseHandler databaseHandler;
    private String tableName;
    private MemoryExampleTable batchExampleTable;
    private int currentBatchStartCursor = -1;
    private int size = -1;
    private int dataManagementType;

    public LimitCachedDatabaseExampleTable(DatabaseHandler databaseHandler, String tableName, int dataManagementType) throws SQLException {
        super(new ArrayList<Attribute>());
        this.databaseHandler = databaseHandler;
        this.tableName = tableName;
        this.dataManagementType = dataManagementType;
        this.initAttributes();
        this.updateBatchAndCursors(0);
    }

    private void initAttributes() throws SQLException {
        Statement attributeStatement = this.databaseHandler.createStatement(false);
        String limitedQuery = this.databaseHandler.getStatementCreator().makeSelectEmptySetStatement(this.tableName);
        ResultSet attributeResultSet = attributeStatement.executeQuery(limitedQuery);
        this.addAttributes(DatabaseHandler.createAttributes(attributeResultSet));
        attributeResultSet.close();
        attributeStatement.close();
    }

    private void updateBatchAndCursors(int desiredRow) throws SQLException {
        boolean newBatch = false;
        int newOffset = this.currentBatchStartCursor;
        if (desiredRow > this.currentBatchStartCursor + 1350) {
            newOffset = desiredRow - 150;
            newBatch = true;
        } else if (desiredRow < this.currentBatchStartCursor) {
            newOffset = desiredRow - 1050;
            newBatch = true;
        }
        if (newOffset < 0) {
            newOffset = 0;
            newBatch = true;
        }
        if (newBatch) {
            Statement batchStatement = this.databaseHandler.createStatement(false);
            String limitedQuery = "SELECT * FROM " + this.databaseHandler.getStatementCreator().makeIdentifier(this.tableName) + " LIMIT " + 1500 + " OFFSET " + newOffset;
            ResultSet batchResultSet = batchStatement.executeQuery(limitedQuery);
            this.batchExampleTable = this.createExampleTableFromBatch(batchResultSet);
            batchResultSet.close();
            batchStatement.close();
            this.currentBatchStartCursor = newOffset;
        }
    }

    private MemoryExampleTable createExampleTableFromBatch(ResultSet batchResultSet) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(this.getAttributes().length);
        for (Attribute attribute : this.getAttributes()) {
            attributes.add(attribute);
        }
        ResultSetDataRowReader reader = new ResultSetDataRowReader(new DataRowFactory(this.dataManagementType, '.'), attributes, batchResultSet);
        return new MemoryExampleTable(attributes, reader);
    }

    @Override
    public DataRow getDataRow(int index) {
        try {
            this.updateBatchAndCursors(index);
            return new NonWritableDataRow(this.batchExampleTable.getDataRow(index - this.currentBatchStartCursor));
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot retrieve data from database: " + e);
        }
    }

    @Override
    public DataRowReader getDataRowReader() {
        return new CachedDataRowReader();
    }

    @Override
    public int size() {
        if (this.size < 0) {
            try {
                Statement countStatement = this.databaseHandler.createStatement(false);
                String countQuery = this.databaseHandler.getStatementCreator().makeSelectSizeStatement(this.tableName);
                ResultSet countResultSet = countStatement.executeQuery(countQuery);
                countResultSet.next();
                this.size = countResultSet.getInt(1);
                countResultSet.close();
                countStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.size;
    }

    private class CachedDataRowReader
    implements DataRowReader {
        private int currentTotalCursor = 0;

        private CachedDataRowReader() {
        }

        @Override
        public boolean hasNext() {
            return this.currentTotalCursor < LimitCachedDatabaseExampleTable.this.size();
        }

        @Override
        public DataRow next() {
            DataRow dataRow = LimitCachedDatabaseExampleTable.this.getDataRow(this.currentTotalCursor);
            ++this.currentTotalCursor;
            return dataRow;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("The method 'remove' is not supported by DataRowReaders on databases!");
        }
    }
}

