/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.table;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.table.AbstractExampleTable;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.DataRowReader;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.example.table.NonWritableDataRow;
import com.rapidminer.example.table.ResultSetDataRowReader;
import com.rapidminer.tools.LoggingHandler;
import com.rapidminer.tools.jdbc.DatabaseHandler;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class IndexCachedDatabaseExampleTable
extends AbstractExampleTable {
    private static final long serialVersionUID = -3514641049341063136L;
    public static final int DEFAULT_BATCH_SIZE = 1500;
    public static final String INDEX_COLUMN_NAME = "RM_INDEX";
    public static final String MAPPING_TABLE_NAME_PREFIX = "RM_MAPPING_";
    private DatabaseHandler databaseHandler;
    private String tableName;
    private MemoryExampleTable batchExampleTable;
    private int currentBatchStartCursor = -1;
    private int size = -1;
    private int dataManagementType;
    private String mappingTableName;
    private String mappingPrimaryKey;

    public IndexCachedDatabaseExampleTable(DatabaseHandler databaseHandler, String tableName, int dataManagementType, boolean dropMappingTable, LoggingHandler logging) throws SQLException {
        super(new ArrayList<Attribute>());
        this.databaseHandler = databaseHandler;
        this.tableName = tableName;
        this.dataManagementType = dataManagementType;
        this.size = this.getSizeForTable(this.tableName);
        this.createIndex(dropMappingTable, logging);
        this.initAttributes();
        this.updateBatchAndCursors(0);
    }

    private void createIndex(boolean dropMappingTable, LoggingHandler logging) throws SQLException {
        String primaryKeyName = this.getPrimaryKeyName(this.tableName);
        if (primaryKeyName == null) {
            this.mappingTableName = null;
            this.mappingPrimaryKey = null;
            logging.logNote("No primary key found: creating a new primary key with name 'RM_INDEX' for table '" + this.tableName + "'. This might take some time...");
            this.createRMPrimaryKeyIndex(this.databaseHandler, this.tableName);
            logging.logNote("Creation of primary key 'RM_INDEX' for table '" + this.tableName + "' finished.");
        } else if (!primaryKeyName.equals(INDEX_COLUMN_NAME)) {
            int mappingSize;
            this.mappingTableName = MAPPING_TABLE_NAME_PREFIX + this.tableName;
            this.mappingPrimaryKey = primaryKeyName;
            Statement statement = this.databaseHandler.createStatement(false);
            boolean exists = false;
            try {
                ResultSet existingResultSet = statement.executeQuery(this.databaseHandler.getStatementCreator().makeSelectEmptySetStatement(this.mappingTableName));
                if (existingResultSet.getMetaData().getColumnCount() > 0) {
                    exists = true;
                }
                existingResultSet.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            statement.close();
            if (exists && (mappingSize = this.getSizeForTable(this.mappingTableName)) != this.size) {
                logging.logWarning("Size of internal mapping table '" + this.mappingTableName + "' and data table '" + this.tableName + "' differs. Recreate new mapping table!");
                dropMappingTable = true;
            }
            if (exists && dropMappingTable) {
                String dropSQL = this.databaseHandler.getStatementCreator().makeDropStatement(this.mappingTableName);
                statement = this.databaseHandler.createStatement(false);
                statement.executeUpdate(dropSQL);
                statement.close();
                exists = false;
            }
            if (!exists) {
                logging.logNote("Primary key '" + primaryKeyName + "' found: creating a new mapping table '" + this.mappingTableName + "' which maps from the RapidMiner index '" + INDEX_COLUMN_NAME + "' to the primary key. This might take some time...");
                String copyKeyQuery = "CREATE TABLE " + this.databaseHandler.getStatementCreator().makeIdentifier(this.mappingTableName) + " AS ( SELECT " + this.databaseHandler.getStatementCreator().makeIdentifier(primaryKeyName) + " FROM " + this.databaseHandler.getStatementCreator().makeIdentifier(this.tableName) + " )";
                statement = this.databaseHandler.createStatement(true);
                statement.execute(copyKeyQuery);
                statement.close();
                logging.logNote("Creating new primary key for mapping table '" + this.mappingTableName + "'...");
                this.createRMPrimaryKeyIndex(this.databaseHandler, this.mappingTableName);
                logging.logNote("Creation of mapping table '" + this.mappingTableName + "' finished.");
            }
        } else {
            this.mappingTableName = null;
            this.mappingPrimaryKey = null;
        }
    }

    protected void createRMPrimaryKeyIndex(DatabaseHandler databaseHandler, String tableName) throws SQLException {
        String addKeyQuery = "ALTER TABLE " + databaseHandler.getStatementCreator().makeIdentifier(tableName) + " ADD " + databaseHandler.getStatementCreator().makeIdentifier(INDEX_COLUMN_NAME) + " INT NOT NULL AUTO_INCREMENT PRIMARY KEY";
        Statement statement = databaseHandler.createStatement(true);
        statement.execute(addKeyQuery);
        statement.close();
    }

    private String getPrimaryKeyName(String tableName) throws SQLException {
        DatabaseMetaData meta = this.databaseHandler.getConnection().getMetaData();
        ResultSet primaryKeys = meta.getPrimaryKeys(null, null, tableName);
        String primaryKeyName = null;
        if (primaryKeys.next()) {
            primaryKeyName = primaryKeys.getString(4);
        }
        primaryKeys.close();
        return primaryKeyName;
    }

    private void initAttributes() throws SQLException {
        Statement attributeStatement = this.databaseHandler.createStatement(false);
        String limitedQuery = this.databaseHandler.getStatementCreator().makeSelectEmptySetStatement(this.tableName);
        ResultSet attributeResultSet = attributeStatement.executeQuery(limitedQuery);
        List<Attribute> attributes = DatabaseHandler.createAttributes(attributeResultSet);
        Iterator<Attribute> a = attributes.iterator();
        while (a.hasNext()) {
            if (!a.next().getName().equals(INDEX_COLUMN_NAME)) continue;
            a.remove();
        }
        this.addAttributes(attributes);
        attributeResultSet.close();
        attributeStatement.close();
    }

    private void updateBatchAndCursors(int desiredRow) throws SQLException {
        boolean newBatch = false;
        int newOffset = this.currentBatchStartCursor;
        if (++desiredRow > this.currentBatchStartCursor + 1350) {
            newOffset = desiredRow - 150;
            newBatch = true;
        } else if (desiredRow < this.currentBatchStartCursor) {
            newOffset = desiredRow - 1050;
            newBatch = true;
        }
        if (newOffset < 1) {
            newOffset = 1;
            newBatch = true;
        }
        if (newBatch) {
            if (this.mappingTableName == null) {
                Statement batchStatement = this.databaseHandler.createStatement(false);
                String limitedQuery = "SELECT * FROM " + this.databaseHandler.getStatementCreator().makeIdentifier(this.tableName) + " WHERE " + this.databaseHandler.getStatementCreator().makeIdentifier(INDEX_COLUMN_NAME) + " >= " + newOffset + " AND " + this.databaseHandler.getStatementCreator().makeIdentifier(INDEX_COLUMN_NAME) + " < " + (newOffset + 1500);
                ResultSet batchResultSet = batchStatement.executeQuery(limitedQuery);
                this.batchExampleTable = this.createExampleTableFromBatch(batchResultSet);
                batchResultSet.close();
                batchStatement.close();
                this.currentBatchStartCursor = newOffset;
            } else {
                Statement batchStatement = this.databaseHandler.createStatement(false);
                String limitedQuery = "SELECT * FROM " + this.databaseHandler.getStatementCreator().makeIdentifier(this.tableName) + "," + this.databaseHandler.getStatementCreator().makeIdentifier(this.mappingTableName) + " WHERE " + this.databaseHandler.getStatementCreator().makeIdentifier(INDEX_COLUMN_NAME) + " >= " + newOffset + " AND " + this.databaseHandler.getStatementCreator().makeIdentifier(INDEX_COLUMN_NAME) + " < " + (newOffset + 1500) + " AND " + this.databaseHandler.getStatementCreator().makeIdentifier(this.tableName) + "." + this.databaseHandler.getStatementCreator().makeIdentifier(this.mappingPrimaryKey) + " = " + this.databaseHandler.getStatementCreator().makeIdentifier(this.mappingTableName) + "." + this.databaseHandler.getStatementCreator().makeIdentifier(this.mappingPrimaryKey);
                ResultSet batchResultSet = batchStatement.executeQuery(limitedQuery);
                this.batchExampleTable = this.createExampleTableFromBatch(batchResultSet);
                batchResultSet.close();
                batchStatement.close();
                this.currentBatchStartCursor = newOffset;
            }
        }
    }

    private MemoryExampleTable createExampleTableFromBatch(ResultSet batchResultSet) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(this.getAttributes().length);
        for (Attribute attribute : this.getAttributes()) {
            attributes.add(attribute);
        }
        ResultSetDataRowReader reader = new ResultSetDataRowReader(new DataRowFactory(this.dataManagementType, '.'), attributes, batchResultSet);
        return new MemoryExampleTable(attributes, reader);
    }

    @Override
    public DataRow getDataRow(int index) {
        try {
            this.updateBatchAndCursors(index);
            return new NonWritableDataRow(this.batchExampleTable.getDataRow(index - this.currentBatchStartCursor + 1));
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot retrieve data from database: " + e, e);
        }
    }

    @Override
    public DataRowReader getDataRowReader() {
        return new CachedDataRowReader();
    }

    private int getSizeForTable(String sizeTable) {
        int size = 0;
        try {
            Statement countStatement = this.databaseHandler.createStatement(false);
            String countQuery = "SELECT count(*) FROM " + this.databaseHandler.getStatementCreator().makeIdentifier(sizeTable);
            ResultSet countResultSet = countStatement.executeQuery(countQuery);
            countResultSet.next();
            size = countResultSet.getInt(1);
            countResultSet.close();
            countStatement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return size;
    }

    @Override
    public int size() {
        return this.size;
    }

    private class CachedDataRowReader
    implements DataRowReader {
        private int currentTotalCursor = 0;

        private CachedDataRowReader() {
        }

        @Override
        public boolean hasNext() {
            return this.currentTotalCursor < IndexCachedDatabaseExampleTable.this.size();
        }

        @Override
        public DataRow next() {
            DataRow dataRow = IndexCachedDatabaseExampleTable.this.getDataRow(this.currentTotalCursor);
            ++this.currentTotalCursor;
            return dataRow;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("The method 'remove' is not supported by DataRowReaders on databases!");
        }
    }
}

