/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.table;

import com.rapidminer.example.Tools;
import com.rapidminer.example.table.DataRow;
import java.util.Arrays;

public class FastSparseDoubleArrayDataRow
extends DataRow {
    private static final long serialVersionUID = -4709836940912838649L;
    private double[] values;
    private int[] tableIndices;
    private int numberOfValues = 0;

    public FastSparseDoubleArrayDataRow(int initialSize) {
        this.values = new double[initialSize];
        this.tableIndices = new int[initialSize];
    }

    @Override
    protected double get(int index, double defaultValue) {
        int valueIndex = Arrays.binarySearch(this.tableIndices, 0, this.numberOfValues, index);
        if (valueIndex >= 0) {
            return this.values[valueIndex];
        }
        return defaultValue;
    }

    @Override
    protected void set(int index, double value, double defaultValue) {
        assert (this.numberOfValues <= this.tableIndices.length);
        assert (this.tableIndices.length == this.values.length);
        int valueIndex = Arrays.binarySearch(this.tableIndices, 0, this.numberOfValues, index);
        if (valueIndex > 0) {
            if (Tools.isDefault(defaultValue, value)) {
                if (valueIndex + 1 < this.values.length) {
                    System.arraycopy(this.values, valueIndex + 1, this.values, valueIndex, this.values.length - valueIndex - 1);
                    System.arraycopy(this.tableIndices, valueIndex + 1, this.tableIndices, valueIndex, this.values.length - valueIndex - 1);
                }
                --this.numberOfValues;
            } else {
                this.values[valueIndex] = value;
            }
        } else if (!Tools.isDefault(defaultValue, value)) {
            int insertionIndex = -(valueIndex + 1);
            if (this.numberOfValues == this.tableIndices.length) {
                double[] newValues = new double[this.values.length + (this.values.length >> 1) + 1];
                int[] newTableIndices = new int[this.values.length + (this.values.length >> 1) + 1];
                System.arraycopy(this.values, 0, newValues, 0, insertionIndex);
                System.arraycopy(this.values, insertionIndex, newValues, insertionIndex + 1, this.numberOfValues - insertionIndex);
                System.arraycopy(this.tableIndices, 0, newTableIndices, 0, insertionIndex);
                System.arraycopy(this.tableIndices, insertionIndex, newTableIndices, insertionIndex + 1, this.numberOfValues - insertionIndex);
                this.values = newValues;
                this.tableIndices = newTableIndices;
            } else {
                System.arraycopy(this.values, insertionIndex, this.values, insertionIndex + 1, this.numberOfValues - insertionIndex);
                System.arraycopy(this.tableIndices, insertionIndex, this.tableIndices, insertionIndex + 1, this.numberOfValues - insertionIndex);
            }
            this.tableIndices[insertionIndex] = index;
            this.values[insertionIndex] = value;
            ++this.numberOfValues;
        }
    }

    @Override
    public void trim() {
        this.values = Arrays.copyOfRange(this.values, 0, this.numberOfValues);
        this.tableIndices = Arrays.copyOfRange(this.tableIndices, 0, this.numberOfValues);
    }

    @Override
    protected void ensureNumberOfColumns(int numberOfColumns) {
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.tableIndices.length; ++i) {
            if (i != 0) {
                result.append(", ");
            }
            result.append(this.tableIndices[i] + ":" + this.values[i]);
        }
        result.append(", counter: " + this.numberOfValues);
        return result.toString();
    }

    @Override
    public int getType() {
        return 7;
    }
}

