/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.table;

import com.rapidminer.example.table.AbstractSparseArrayDataRow;

public class DoubleSparseArrayDataRow
extends AbstractSparseArrayDataRow {
    private static final long serialVersionUID = 9137639592169696234L;
    private double[] values;

    public DoubleSparseArrayDataRow() {
        this(0);
    }

    public DoubleSparseArrayDataRow(int size) {
        super(size);
        this.values = new double[size];
    }

    @Override
    protected void swapValues(int a, int b) {
        double tt = this.values[a];
        this.values[a] = this.values[b];
        this.values[b] = tt;
    }

    @Override
    public void resizeValues(int length) {
        double[] d = new double[length];
        System.arraycopy(this.values, 0, d, 0, Math.min(this.values.length, length));
        this.values = d;
    }

    @Override
    public void removeValue(int index) {
        System.arraycopy(this.values, index + 1, this.values, index, this.values.length - (index + 1));
    }

    @Override
    public double getValue(int index) {
        return this.values[index];
    }

    @Override
    public void setValue(int index, double v) {
        this.values[index] = v;
    }

    @Override
    protected double[] getAllValues() {
        return this.values;
    }

    @Override
    public int getType() {
        return 7;
    }
}

