/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.table;

import com.rapidminer.example.MinMaxStatistics;
import com.rapidminer.example.UnknownStatistics;
import com.rapidminer.example.table.AbstractAttribute;
import com.rapidminer.example.table.NominalMapping;
import com.rapidminer.tools.Tools;
import java.util.Date;

public class DateAttribute
extends AbstractAttribute {
    private static final long serialVersionUID = -685655991653799960L;

    DateAttribute(String name) {
        this(name, 10);
    }

    DateAttribute(String name, int valueType) {
        super(name, valueType);
        this.registerStatistics(new MinMaxStatistics());
        this.registerStatistics(new UnknownStatistics());
    }

    private DateAttribute(DateAttribute a) {
        super(a);
    }

    @Override
    public Object clone() {
        return new DateAttribute(this);
    }

    @Override
    public String getAsString(double value, int digits, boolean quoteNominal) {
        if (Double.isNaN(value)) {
            return "?";
        }
        long milliseconds = (long)value;
        String result = null;
        if (this.getValueType() == 10) {
            result = Tools.formatDate(new Date(milliseconds));
        } else if (this.getValueType() == 11) {
            result = Tools.formatTime(new Date(milliseconds));
        } else if (this.getValueType() == 9) {
            result = Tools.formatDateTime(new Date(milliseconds));
        }
        if (quoteNominal) {
            result = "\"" + result + "\"";
        }
        return result;
    }

    @Override
    public NominalMapping getMapping() {
        throw new UnsupportedOperationException("The method getNominalMapping() is not supported by date attributes! You probably tried to execute an operator on a date or time data which is only able to handle nominal values. You could use one of the Date to Nominal operator before this application.");
    }

    @Override
    public boolean isNominal() {
        return false;
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    @Override
    public void setMapping(NominalMapping nominalMapping) {
    }
}

