/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.table;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.table.AbstractExampleTable;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowReader;
import com.rapidminer.example.table.DatabaseDataRow;
import com.rapidminer.example.table.DatabaseDataRowReader;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.jdbc.DatabaseHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public class DatabaseExampleTable
extends AbstractExampleTable {
    private static final long serialVersionUID = -3683705313093987482L;
    private transient ResultSet resultSet;
    private transient DatabaseHandler databaseHandler;
    private transient Statement statement;
    private String tableName;
    private int size = 0;

    private DatabaseExampleTable(List<Attribute> attributes, DatabaseHandler databaseHandler, String tableName) throws SQLException {
        super(attributes);
        this.databaseHandler = databaseHandler;
        this.tableName = tableName;
        this.resetResultSet();
    }

    public static DatabaseExampleTable createDatabaseExampleTable(DatabaseHandler databaseHandler, String tableName) throws SQLException {
        Statement statement = databaseHandler.createStatement(false);
        ResultSet rs = statement.executeQuery(databaseHandler.getStatementCreator().makeSelectEmptySetStatement(tableName));
        List<Attribute> attributes = DatabaseHandler.createAttributes(rs);
        rs.close();
        statement.close();
        DatabaseExampleTable table = new DatabaseExampleTable(attributes, databaseHandler, tableName);
        return table;
    }

    private void resetResultSet() throws SQLException {
        if (this.statement != null) {
            this.statement.close();
            this.statement = null;
        }
        this.statement = this.databaseHandler.createStatement(true);
        this.resultSet = this.statement.executeQuery(this.databaseHandler.getStatementCreator().makeSelectAllStatement(this.tableName));
    }

    @Override
    public DataRowReader getDataRowReader() {
        try {
            return new DatabaseDataRowReader(this.resultSet);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error while creating database DataRowReader: " + e, e);
        }
    }

    @Override
    public DataRow getDataRow(int index) {
        try {
            this.resultSet.absolute(index + 1);
            DatabaseDataRow dataRow = new DatabaseDataRow(this.resultSet);
            return dataRow;
        }
        catch (SQLException e) {
            LogService.getGlobal().log("Cannot retrieve data row with absolute row index: " + e.getMessage(), 5);
            return null;
        }
    }

    @Override
    public int addAttribute(Attribute attribute) {
        int index = super.addAttribute(attribute);
        if (this.databaseHandler == null) {
            return index;
        }
        try {
            this.close();
            this.databaseHandler.addColumn(attribute, this.tableName);
            this.resetResultSet();
        }
        catch (SQLException e) {
            throw new RuntimeException("Error while adding a column '" + attribute.getName() + "'to database: " + e, e);
        }
        return index;
    }

    @Override
    public void removeAttribute(Attribute attribute) {
        super.removeAttribute(attribute);
        try {
            this.close();
            this.databaseHandler.removeColumn(attribute, this.tableName);
            this.resetResultSet();
        }
        catch (SQLException e) {
            throw new RuntimeException("Error while removing a column '" + attribute.getName() + "' from database: " + e, e);
        }
    }

    @Override
    public int size() {
        if (this.size < 0) {
            try {
                Statement countStatement = this.databaseHandler.createStatement(false);
                String countQuery = this.databaseHandler.getStatementCreator().makeSelectSizeStatement(this.tableName);
                ResultSet countResultSet = countStatement.executeQuery(countQuery);
                countResultSet.next();
                this.size = countResultSet.getInt(1);
                countResultSet.close();
                countStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.size;
    }

    private void close() {
        if (this.statement != null) {
            try {
                this.statement.close();
                this.statement = null;
            }
            catch (SQLException e) {
                LogService.getGlobal().log("DatabaseExampleTable: cannot close result set: " + e.getMessage(), 5);
            }
        }
    }

    protected void finalize() {
        this.close();
    }
}

