/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.table;

import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowReader;
import com.rapidminer.example.table.DatabaseDataRow;
import com.rapidminer.tools.LogService;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DatabaseDataRowReader
implements DataRowReader {
    private ResultSet resultSet;
    private static final int DONT_KNOW_YET = 0;
    private static final int YES = 1;
    private static final int NO = 2;
    private int hasNext = 0;

    public DatabaseDataRowReader(ResultSet resultSet) throws SQLException {
        this.resultSet = resultSet;
        this.resultSet.beforeFirst();
    }

    @Override
    public boolean hasNext() {
        switch (this.hasNext) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 0: {
                try {
                    if (this.resultSet.next()) {
                        this.hasNext = 1;
                        return true;
                    }
                    this.hasNext = 2;
                    return false;
                }
                catch (SQLException e) {
                    LogService.getGlobal().logError("While reading examples from result set: " + e.getMessage());
                    return false;
                }
            }
        }
        return false;
    }

    @Override
    public DataRow next() {
        if (this.hasNext()) {
            this.hasNext = 0;
            try {
                return new DatabaseDataRow(this.resultSet);
            }
            catch (SQLException sqle) {
                throw new RuntimeException("Error accessing the result of a query:" + sqle.toString(), sqle);
            }
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("The method 'remove' is not supported by DataRowReaders on databases!");
    }
}

