/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.table;

import com.rapidminer.example.AttributeTypeException;
import com.rapidminer.example.table.NominalMapping;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class BinominalMapping
implements NominalMapping {
    private static final long serialVersionUID = 6566553739308153153L;
    private static final int FIRST_VALUE_INDEX = 0;
    private static final int SECOND_VALUE_INDEX = 1;
    private String firstValue = null;
    private String secondValue = null;

    public BinominalMapping() {
    }

    private BinominalMapping(BinominalMapping mapping) {
        this.firstValue = mapping.firstValue;
        this.secondValue = mapping.secondValue;
    }

    BinominalMapping(NominalMapping mapping) {
        if (mapping.size() > 0) {
            this.firstValue = mapping.mapIndex(0);
        }
        if (mapping.size() > 1) {
            this.secondValue = mapping.mapIndex(1);
        }
    }

    @Override
    public Object clone() {
        return new BinominalMapping(this);
    }

    @Override
    public boolean equals(NominalMapping mapping) {
        if (mapping.size() != this.size()) {
            return false;
        }
        for (String value : mapping.getValues()) {
            if (value.equals(this.firstValue) || value.equals(this.secondValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int mapString(String str) {
        if (str == null) {
            return -1;
        }
        int index = this.getIndex(str);
        if (index < 0) {
            if (this.firstValue == null) {
                this.firstValue = new String(str);
                return 0;
            }
            if (this.secondValue == null) {
                this.secondValue = new String(str);
                return 1;
            }
            throw new AttributeTypeException("Cannot map another string for binary attribute: already mapped two strings (" + this.firstValue + ", " + this.secondValue + "). The third string that was tried to add: <tt>" + str + "</tt>");
        }
        return index;
    }

    @Override
    public int getIndex(String str) {
        if (str.equals(this.firstValue)) {
            return 0;
        }
        if (str.equals(this.secondValue)) {
            return 1;
        }
        return -1;
    }

    @Override
    public String mapIndex(int index) {
        switch (index) {
            case 0: {
                return this.firstValue;
            }
            case 1: {
                return this.secondValue;
            }
        }
        throw new AttributeTypeException("Cannot map index of binary attribute to nominal value: index " + index + " is out of bounds!");
    }

    @Override
    public void setMapping(String nominalValue, int index) {
        if (index == 0) {
            this.firstValue = nominalValue;
        } else if (index == 1) {
            this.secondValue = nominalValue;
        } else {
            throw new AttributeTypeException("Cannot set mapping of binary attribute to index '" + index + "'.");
        }
    }

    @Override
    public int getNegativeIndex() {
        return 0;
    }

    @Override
    public int getPositiveIndex() {
        return 1;
    }

    @Override
    public String getNegativeString() {
        return this.firstValue;
    }

    @Override
    public String getPositiveString() {
        return this.secondValue;
    }

    @Override
    public List<String> getValues() {
        if (this.firstValue == null) {
            return new LinkedList<String>();
        }
        if (this.secondValue == null) {
            return Arrays.asList(this.firstValue);
        }
        return Arrays.asList(this.firstValue, this.secondValue);
    }

    @Override
    public int size() {
        if (this.firstValue == null) {
            return 0;
        }
        if (this.secondValue == null) {
            return 1;
        }
        return 2;
    }

    @Override
    public void sortMappings() {
        if (this.size() == 2 && this.firstValue.compareTo(this.secondValue) > 0) {
            String dummy = this.secondValue;
            this.secondValue = this.firstValue;
            this.firstValue = dummy;
        }
    }

    @Override
    public void clear() {
        this.firstValue = null;
        this.secondValue = null;
    }
}

