/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.table;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.table.BinominalAttribute;
import com.rapidminer.example.table.DateAttribute;
import com.rapidminer.example.table.NumericalAttribute;
import com.rapidminer.example.table.PolynominalAttribute;
import com.rapidminer.tools.Ontology;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class AttributeFactory {
    private static final String GENSYM_PREFIX = "gensym";
    private static Map<String, AtomicInteger> nameCounters = new HashMap<String, AtomicInteger>();

    public static Attribute createAttribute(String name, int valueType) {
        String attributeName;
        String string = attributeName = name != null ? new String(name) : AttributeFactory.createName();
        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueType, 9)) {
            return new DateAttribute(attributeName, valueType);
        }
        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueType, 6)) {
            return new BinominalAttribute(attributeName);
        }
        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueType, 1)) {
            return new PolynominalAttribute(attributeName, valueType);
        }
        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueType, 2)) {
            return new NumericalAttribute(attributeName, valueType);
        }
        throw new RuntimeException("AttributeFactory: cannot create attribute with value type '" + Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(valueType) + "' (" + valueType + ")!");
    }

    public static Attribute createAttribute(int valueType) {
        return AttributeFactory.createAttribute(AttributeFactory.createName(), valueType);
    }

    public static Attribute createAttribute(int valueType, int blockType, String constructionDescription) {
        Attribute attribute = AttributeFactory.createAttribute(valueType);
        attribute.setBlockType(blockType);
        attribute.setConstruction(constructionDescription);
        return attribute;
    }

    public static Attribute createAttribute(String name, int valueType, int blockType) {
        Attribute attribute = AttributeFactory.createAttribute(name, valueType);
        attribute.setBlockType(blockType);
        return attribute;
    }

    public static Attribute createAttribute(Attribute attribute) {
        return AttributeFactory.createAttribute(attribute, null);
    }

    public static Attribute createAttribute(Attribute attribute, String functionName) {
        Attribute result = (Attribute)attribute.clone();
        if (functionName == null) {
            result.setName(attribute.getName());
        } else {
            result.setName(functionName + "(" + attribute.getName() + ")");
            result.setConstruction(functionName + "(" + attribute.getName() + ")");
        }
        return result;
    }

    public static Attribute changeValueType(Attribute attribute, int valueType) {
        Attribute result = AttributeFactory.createAttribute(attribute.getName(), valueType);
        if (attribute.isNominal() && result.isNominal()) {
            result.setMapping(attribute.getMapping());
        }
        result.setTableIndex(attribute.getTableIndex());
        return result;
    }

    public static void resetNameCounters() {
        nameCounters.clear();
    }

    public static String createName() {
        return AttributeFactory.createName(GENSYM_PREFIX);
    }

    public static String createName(String prefix) {
        AtomicInteger counter = nameCounters.get(prefix);
        if (counter == null) {
            nameCounters.put(prefix, new AtomicInteger(1));
            return prefix;
        }
        return prefix + counter.getAndIncrement();
    }

    static {
        AttributeFactory.resetNameCounters();
    }
}

