/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.set;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.PartitionBuilder;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.RandomGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;

public class StratifiedPartitionBuilder
implements PartitionBuilder {
    private ExampleSet exampleSet;
    private Random random;

    public StratifiedPartitionBuilder(ExampleSet exampleSet, boolean useLocalRandomSeed, int seed) {
        this.exampleSet = exampleSet;
        this.random = RandomGenerator.getRandomGenerator(useLocalRandomSeed, seed);
    }

    @Override
    public int[] createPartition(double[] ratio, int size) {
        Attribute label = this.exampleSet.getAttributes().getLabel();
        if (size != this.exampleSet.size()) {
            throw new RuntimeException("Cannot create stratified Partition: given size and size of the example set must be equal!");
        }
        if (label == null) {
            throw new RuntimeException("Cannot create stratified Partition: example set must have a label!");
        }
        if (!label.isNominal()) {
            throw new RuntimeException("Cannot create stratified Partition: label of example set must be nominal!");
        }
        double firstValue = ratio[0];
        for (int i = 1; i < ratio.length; ++i) {
            if (ratio[i] == firstValue) continue;
            LogService.getGlobal().log("Not all ratio values are equal: using non-equal stratified sampling.", 2);
            return this.createNonEqualPartition(ratio, size, label);
        }
        LogService.getGlobal().log("All ratio values are equal: using stratified sampling.", 2);
        return this.createEqualPartition(ratio, size, label);
    }

    private int[] createEqualPartition(double[] ratio, int size, Attribute label) {
        ArrayList<ExampleIndex> examples = new ArrayList<ExampleIndex>(size);
        Iterator reader = this.exampleSet.iterator();
        int index = 0;
        while (reader.hasNext()) {
            Example example = (Example)reader.next();
            examples.add(new ExampleIndex(index++, example.getNominalValue(label)));
        }
        Collections.shuffle(examples, this.random);
        Collections.sort(examples);
        ArrayList newExamples = new ArrayList(size);
        int start = 0;
        int numberOfPartitions = ratio.length;
        while (newExamples.size() < size) {
            for (int i = start; i < examples.size(); i += numberOfPartitions) {
                newExamples.add(examples.get(i));
            }
            ++start;
        }
        int[] startNewP = new int[ratio.length + 1];
        startNewP[0] = 0;
        double ratioSum = 0.0;
        for (int i = 1; i < startNewP.length; ++i) {
            startNewP[i] = (int)Math.round((double)newExamples.size() * (ratioSum += ratio[i - 1]));
        }
        int[] part = new int[newExamples.size()];
        int p = 0;
        int counter = 0;
        Iterator n = newExamples.iterator();
        while (n.hasNext()) {
            if (counter >= startNewP[p + 1]) {
                // empty if block
            }
            ExampleIndex exampleIndex = (ExampleIndex)n.next();
            part[exampleIndex.exampleIndex] = ++p;
            ++counter;
        }
        return part;
    }

    private int[] createNonEqualPartition(double[] ratio, int size, Attribute label) {
        HashMap<String, LinkedList<Integer>> classLists = new HashMap<String, LinkedList<Integer>>();
        Iterator reader = this.exampleSet.iterator();
        int index = 0;
        while (reader.hasNext()) {
            Example example = (Example)reader.next();
            String value = example.getNominalValue(label);
            LinkedList<Integer> classList = (LinkedList<Integer>)classLists.get(value);
            if (classList == null) {
                classList = new LinkedList<Integer>();
                classList.add(index++);
                classLists.put(value, classList);
                continue;
            }
            classList.add(index++);
        }
        int[] part = new int[this.exampleSet.size()];
        for (LinkedList<Integer> classList : classLists.values()) {
            Collections.shuffle(classList, this.random);
            int[] startNewP = new int[ratio.length + 1];
            startNewP[0] = 0;
            double ratioSum = 0.0;
            for (int i = 1; i < startNewP.length; ++i) {
                startNewP[i] = (int)Math.round((double)classList.size() * (ratioSum += ratio[i - 1]));
            }
            int p = 0;
            int counter = 0;
            Iterator n = classList.iterator();
            while (n.hasNext()) {
                if (counter >= startNewP[p + 1]) {
                    // empty if block
                }
                Integer exampleIndex = (Integer)n.next();
                part[exampleIndex.intValue()] = ++p;
                ++counter;
            }
        }
        return part;
    }

    private static class ExampleIndex
    implements Comparable<ExampleIndex> {
        int exampleIndex;
        String className;

        public ExampleIndex(int exampleIndex, String className) {
            this.exampleIndex = exampleIndex;
            this.className = className;
        }

        @Override
        public int compareTo(ExampleIndex e) {
            return this.className.compareTo(e.className);
        }

        public boolean equals(Object o) {
            if (!(o instanceof ExampleIndex)) {
                return false;
            }
            ExampleIndex other = (ExampleIndex)o;
            return this.exampleIndex == other.exampleIndex;
        }

        public int hashCode() {
            return Integer.valueOf(this.exampleIndex).hashCode();
        }

        public String toString() {
            return this.exampleIndex + "(" + this.className + ")";
        }
    }
}

