/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.set;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.set.AbstractExampleReader;
import java.util.Iterator;

public class SkipNANExampleReader
extends AbstractExampleReader {
    private Iterator<Example> reader;
    private Example currentExample;

    public SkipNANExampleReader(Iterator<Example> reader) {
        this.reader = reader;
        this.currentExample = null;
    }

    @Override
    public boolean hasNext() {
        if (this.currentExample == null) {
            while (this.reader.hasNext()) {
                Example e = this.reader.next();
                if (this.containsNAN(e)) continue;
                this.currentExample = e;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public Example next() {
        this.hasNext();
        Example dummy = this.currentExample;
        this.currentExample = null;
        return dummy;
    }

    private boolean containsNAN(Example e) {
        for (Attribute attribute : e.getAttributes()) {
            if (!Double.isNaN(e.getValue(attribute))) continue;
            return true;
        }
        return false;
    }
}

