/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.set;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.AbstractExampleReader;
import com.rapidminer.example.set.AbstractExampleSet;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.ExampleTable;
import java.util.Iterator;

public class SingleExampleExampleSet
extends AbstractExampleSet {
    private static final long serialVersionUID = -4817219403776439504L;
    private ExampleSet parent;
    private Example example;

    public SingleExampleExampleSet(ExampleSet exampleSet, Example example) {
        this.parent = (ExampleSet)exampleSet.clone();
        this.example = example;
    }

    public SingleExampleExampleSet(SingleExampleExampleSet exampleSet) {
        this.parent = (ExampleSet)exampleSet.parent.clone();
        this.example = exampleSet.example;
    }

    @Override
    public Iterator<Example> iterator() {
        return new SingleExampleIterator(this.example.getDataRow(), this);
    }

    @Override
    public Example getExample(int index) {
        if (index == 0) {
            return new Example(this.example.getDataRow(), this);
        }
        return null;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public Example getExampleFromId(double id) {
        Attribute idAttribute = this.getAttributes().getId();
        if (idAttribute != null) {
            Example newExample = new Example(this.example.getDataRow(), this);
            if (newExample.getValue(idAttribute) == id) {
                return newExample;
            }
            return null;
        }
        return null;
    }

    @Override
    public Attributes getAttributes() {
        return this.parent.getAttributes();
    }

    @Override
    public ExampleTable getExampleTable() {
        return this.parent.getExampleTable();
    }

    private static class SingleExampleIterator
    extends AbstractExampleReader {
        private boolean nextCalled = false;
        private DataRow dataRow;
        private SingleExampleExampleSet exampleSet;

        public SingleExampleIterator(DataRow dataRow, SingleExampleExampleSet exampleSet) {
            this.dataRow = dataRow;
            this.exampleSet = exampleSet;
        }

        @Override
        public boolean hasNext() {
            return !this.nextCalled;
        }

        @Override
        public Example next() {
            if (!this.nextCalled) {
                this.nextCalled = true;
                return new Example(this.dataRow, this.exampleSet);
            }
            return null;
        }
    }
}

