/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.set;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.SimpleAttributes;
import com.rapidminer.example.set.AbstractExampleReader;
import com.rapidminer.example.set.AbstractExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.example.table.NominalMapping;
import com.rapidminer.tools.math.similarity.DistanceMeasure;
import java.util.Iterator;

public class SimilarityExampleSet
extends AbstractExampleSet {
    private static final long serialVersionUID = 4757975818441794105L;
    private ExampleSet parent;
    private Attribute parentIdAttribute;
    private Attributes attributes;
    private DistanceMeasure measure;

    public SimilarityExampleSet(ExampleSet parent, DistanceMeasure measure) {
        this.parent = parent;
        this.parentIdAttribute = parent.getAttributes().getId();
        this.attributes = new SimpleAttributes();
        Attribute firstIdAttribute = null;
        Attribute secondIdAttribute = null;
        firstIdAttribute = AttributeFactory.createAttribute("FIRST_ID", this.parentIdAttribute.getValueType());
        secondIdAttribute = AttributeFactory.createAttribute("SECOND_ID", this.parentIdAttribute.getValueType());
        this.attributes.addRegular(firstIdAttribute);
        this.attributes.addRegular(secondIdAttribute);
        firstIdAttribute.setTableIndex(0);
        secondIdAttribute.setTableIndex(1);
        if (this.parentIdAttribute.isNominal()) {
            NominalMapping mapping = this.parentIdAttribute.getMapping();
            firstIdAttribute.setMapping((NominalMapping)mapping.clone());
            secondIdAttribute.setMapping((NominalMapping)mapping.clone());
        }
        String name = "SIMILARITY";
        if (measure.isDistance()) {
            name = "DISTANCE";
        }
        Attribute similarityAttribute = AttributeFactory.createAttribute(name, 4);
        this.attributes.addRegular(similarityAttribute);
        similarityAttribute.setTableIndex(2);
        this.measure = measure;
    }

    public SimilarityExampleSet(SimilarityExampleSet exampleSet) {
        this.parent = (ExampleSet)exampleSet.parent.clone();
        this.parentIdAttribute = (Attribute)exampleSet.parentIdAttribute.clone();
        this.attributes = (Attributes)exampleSet.attributes.clone();
        this.measure = exampleSet.measure;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof SimilarityExampleSet)) {
            return false;
        }
        SimilarityExampleSet other = (SimilarityExampleSet)o;
        return this.measure.getClass().equals(other.measure.getClass());
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.measure.getClass().hashCode();
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public Example getExample(int index) {
        int firstIndex = index / this.parent.size();
        int secondIndex = index % this.parent.size();
        Example firstExample = this.parent.getExample(firstIndex);
        Example secondExample = this.parent.getExample(secondIndex);
        double[] data = new double[]{firstExample.getValue(this.parentIdAttribute), secondExample.getValue(this.parentIdAttribute), this.measure.isDistance() ? this.measure.calculateDistance(firstExample, secondExample) : this.measure.calculateSimilarity(firstExample, secondExample)};
        return new Example(new DoubleArrayDataRow(data), this);
    }

    @Override
    public Iterator<Example> iterator() {
        return new IndexExampleReader(this);
    }

    @Override
    public ExampleTable getExampleTable() {
        return null;
    }

    @Override
    public int size() {
        return this.parent.size() * this.parent.size();
    }

    private static class IndexExampleReader
    extends AbstractExampleReader {
        private int index = 0;
        private ExampleSet exampleSet;

        public IndexExampleReader(ExampleSet exampleSet) {
            this.exampleSet = exampleSet;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.exampleSet.size() - 1;
        }

        @Override
        public Example next() {
            Example example = this.exampleSet.getExample(this.index);
            ++this.index;
            return example;
        }
    }
}

