/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.set;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.AbstractExampleSet;
import com.rapidminer.example.set.AttributeTransformationRemapping;
import com.rapidminer.example.set.AttributesExampleReader;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.example.table.NominalMapping;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class RemappedExampleSet
extends AbstractExampleSet {
    private static final long serialVersionUID = 3460640319989955936L;
    private ExampleSet parent;

    public RemappedExampleSet(ExampleSet parentSet, ExampleSet mappingSet) {
        this(parentSet, mappingSet, true);
    }

    public RemappedExampleSet(ExampleSet parentSet, ExampleSet _mappingSet, boolean keepAdditional) {
        this.parent = (ExampleSet)parentSet.clone();
        ExampleSet mappingSet = (ExampleSet)_mappingSet.clone();
        if (mappingSet != null) {
            Attributes attributes = this.parent.getAttributes();
            LinkedHashMap<String, Attribute> attributeMap = new LinkedHashMap<String, Attribute>(this.parent.size());
            for (Attribute attribute : attributes) {
                attributeMap.put(attribute.getName(), attribute);
            }
            attributes.clearRegular();
            for (Attribute mapAttribute : mappingSet.getAttributes()) {
                String name = mapAttribute.getName();
                Attribute attribute = (Attribute)attributeMap.get(name);
                if (attribute == null) continue;
                attributes.addRegular(attribute);
                attributeMap.remove(name);
            }
            if (keepAdditional) {
                for (Attribute attribute : attributeMap.values()) {
                    attributes.addRegular(attribute);
                }
            }
            Iterator<AttributeRole> a = this.parent.getAttributes().allAttributeRoles();
            while (a.hasNext()) {
                AttributeRole role = a.next();
                Attribute currentAttribute = role.getAttribute();
                if (!currentAttribute.isNominal()) continue;
                NominalMapping mapping = null;
                mapping = currentAttribute.getMapping();
                Attribute oldMappingAttribute = mappingSet.getAttributes().get(role.getAttribute().getName());
                if (oldMappingAttribute != null && oldMappingAttribute.isNominal()) {
                    mapping = oldMappingAttribute.getMapping();
                }
                currentAttribute.addTransformation(new AttributeTransformationRemapping(mapping));
            }
        }
    }

    public RemappedExampleSet(RemappedExampleSet other) {
        this.parent = (ExampleSet)other.parent.clone();
    }

    @Override
    public Attributes getAttributes() {
        return this.parent.getAttributes();
    }

    @Override
    public ExampleTable getExampleTable() {
        return this.parent.getExampleTable();
    }

    @Override
    public int size() {
        return this.parent.size();
    }

    @Override
    public Iterator<Example> iterator() {
        return new AttributesExampleReader(this.parent.iterator(), this);
    }

    @Override
    public Example getExample(int index) {
        return this.parent.getExample(index);
    }
}

