/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.set;

import com.rapidminer.example.set.PartitionBuilder;
import com.rapidminer.tools.LogService;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;

public class Partition
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 6126334515107973287L;
    private boolean[] mask;
    private int[] partitionSizes;
    private int[] elements;
    private int[] lastElementIndex;
    private int[] tableIndexMap = null;

    public Partition(double[] ratio, int size, PartitionBuilder builder) {
        this.init(ratio, size, builder);
    }

    public Partition(int noPartitions, int size, PartitionBuilder builder) {
        double[] ratio = new double[noPartitions];
        for (int i = 0; i < ratio.length; ++i) {
            ratio[i] = 1.0 / (double)noPartitions;
        }
        this.init(ratio, size, builder);
    }

    public Partition(int[] elements, int numberOfPartitions) {
        this.init(elements, numberOfPartitions);
    }

    private Partition(Partition p) {
        this.partitionSizes = new int[p.partitionSizes.length];
        System.arraycopy(p.partitionSizes, 0, this.partitionSizes, 0, p.partitionSizes.length);
        this.mask = new boolean[p.mask.length];
        System.arraycopy(p.mask, 0, this.mask, 0, p.mask.length);
        this.elements = new int[p.elements.length];
        System.arraycopy(p.elements, 0, this.elements, 0, p.elements.length);
        this.lastElementIndex = new int[p.lastElementIndex.length];
        System.arraycopy(p.lastElementIndex, 0, this.lastElementIndex, 0, p.lastElementIndex.length);
        this.recalculateTableIndices();
    }

    private void init(double[] ratio, int size, PartitionBuilder builder) {
        LogService.getGlobal().log("Create new partition using a '" + builder.getClass().getName() + "'.", 2);
        this.elements = builder.createPartition(ratio, size);
        this.init(this.elements, ratio.length);
    }

    private void init(int[] newElements, int noOfPartitions) {
        int i;
        LogService.getGlobal().log("Create new partition with " + newElements.length + " elements and " + noOfPartitions + " partitions.", 2);
        this.partitionSizes = new int[noOfPartitions];
        this.lastElementIndex = new int[noOfPartitions];
        this.elements = newElements;
        for (i = 0; i < this.elements.length; ++i) {
            if (this.elements[i] < 0) continue;
            int n = this.elements[i];
            this.partitionSizes[n] = this.partitionSizes[n] + 1;
            this.lastElementIndex[this.elements[i]] = i;
        }
        this.mask = new boolean[noOfPartitions];
        for (i = 0; i < this.mask.length; ++i) {
            this.mask[i] = true;
        }
        this.recalculateTableIndices();
    }

    public boolean equals(Object o) {
        int i;
        if (!(o instanceof Partition)) {
            return false;
        }
        Partition other = (Partition)o;
        for (i = 0; i < this.mask.length; ++i) {
            if (this.mask[i] == other.mask[i]) continue;
            return false;
        }
        for (i = 0; i < this.elements.length; ++i) {
            if (this.elements[i] == other.elements[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int i;
        int hc = 17;
        int hashMultiplier = 59;
        hc = hc * hashMultiplier + this.mask.length;
        for (i = 1; i < this.mask.length; i <<= 1) {
            hc = hc * hashMultiplier + Boolean.valueOf(this.mask[i]).hashCode();
        }
        hc = hc * hashMultiplier + this.elements.length;
        for (i = 1; i < this.elements.length; i <<= 1) {
            hc = hc * hashMultiplier + Integer.valueOf(this.elements[i]).hashCode();
        }
        return hc;
    }

    public boolean hasNext(int index) {
        for (int p = 0; p < this.mask.length; ++p) {
            if (!this.mask[p] || index > this.lastElementIndex[p]) continue;
            return true;
        }
        return false;
    }

    public void clearSelection() {
        this.mask = new boolean[this.mask.length];
        this.recalculateTableIndices();
    }

    public void invertSelection() {
        for (int i = 0; i < this.mask.length; ++i) {
            this.mask[i] = !this.mask[i];
        }
        this.recalculateTableIndices();
    }

    public void selectSubset(int i) {
        this.mask[i] = true;
        this.recalculateTableIndices();
    }

    public void deselectSubset(int i) {
        this.mask[i] = false;
        this.recalculateTableIndices();
    }

    public int getNumberOfSubsets() {
        return this.partitionSizes.length;
    }

    public int getSelectionSize() {
        int s = 0;
        for (int i = 0; i < this.partitionSizes.length; ++i) {
            if (!this.mask[i]) continue;
            s += this.partitionSizes[i];
        }
        return s;
    }

    public int getTotalSize() {
        return this.elements.length;
    }

    public boolean isSelected(int index) {
        return this.mask[this.elements[index]];
    }

    private void recalculateTableIndices() {
        LinkedList<Integer> indices = new LinkedList<Integer>();
        for (int i = 0; i < this.elements.length; ++i) {
            if (!this.mask[this.elements[i]]) continue;
            indices.add(i);
        }
        this.tableIndexMap = new int[indices.size()];
        Iterator i = indices.iterator();
        int counter = 0;
        while (i.hasNext()) {
            this.tableIndexMap[counter++] = (Integer)i.next();
        }
    }

    public int mapIndex(int index) {
        return this.tableIndexMap[index];
    }

    public String toString() {
        StringBuffer str = new StringBuffer("(");
        for (int i = 0; i < this.partitionSizes.length; ++i) {
            str.append((i != 0 ? "/" : "") + this.partitionSizes[i]);
        }
        str.append(")");
        return str.toString();
    }

    public Object clone() {
        return new Partition(this);
    }
}

