/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.set;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.Condition;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class NoMissingAttributeValueCondition
implements Condition {
    private static final long serialVersionUID = -6043772701857922762L;
    private Collection<Attribute> checkedAttributes = new LinkedList<Attribute>();

    public NoMissingAttributeValueCondition(ExampleSet exampleSet, String parameterString) {
        Iterator<Attribute> iterator = exampleSet.getAttributes().allAttributes();
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            if (!attribute.getName().matches(parameterString)) continue;
            this.checkedAttributes.add(attribute);
        }
    }

    @Override
    public boolean conditionOk(Example example) {
        boolean isOk = true;
        for (Attribute attribute : this.checkedAttributes) {
            isOk &= !Double.isNaN(example.getValue(attribute));
        }
        return isOk;
    }

    @Override
    @Deprecated
    public Condition duplicate() {
        return this;
    }
}

