/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.set;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.AbstractExampleSet;
import com.rapidminer.example.set.MappedExampleReader;
import com.rapidminer.example.table.ExampleTable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;

public class MappedExampleSet
extends AbstractExampleSet {
    private static final long serialVersionUID = -488025806523583178L;
    private ExampleSet parent;
    private int[] mapping;

    public MappedExampleSet(ExampleSet parent, int[] mapping) {
        this(parent, mapping, true);
    }

    public MappedExampleSet(ExampleSet parent, int[] mapping, boolean useMappedExamples) {
        this(parent, mapping, useMappedExamples, true);
    }

    public MappedExampleSet(ExampleSet parent, int[] mapping, boolean useMappedExamples, boolean sort) {
        this.parent = (ExampleSet)parent.clone();
        this.mapping = mapping;
        if (sort) {
            Arrays.sort(this.mapping);
        }
        if (!useMappedExamples) {
            ArrayList<Integer> inverseIndexList = new ArrayList<Integer>();
            int currentExample = -1;
            for (int m : mapping) {
                if (m == currentExample) continue;
                for (int z = currentExample + 1; z < m; ++z) {
                    inverseIndexList.add(z);
                }
                currentExample = m;
            }
            this.mapping = new int[inverseIndexList.size()];
            Iterator i = inverseIndexList.iterator();
            int index = 0;
            while (i.hasNext()) {
                this.mapping[index++] = (Integer)i.next();
            }
        }
    }

    public MappedExampleSet(MappedExampleSet exampleSet) {
        this.parent = (ExampleSet)exampleSet.parent.clone();
        this.mapping = exampleSet.mapping;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof MappedExampleSet)) {
            return false;
        }
        MappedExampleSet other = (MappedExampleSet)o;
        if (this.mapping.length != other.mapping.length) {
            return false;
        }
        for (int i = 0; i < this.mapping.length; ++i) {
            if (this.mapping[i] == other.mapping[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Arrays.hashCode(this.mapping);
    }

    @Override
    public Iterator<Example> iterator() {
        return new MappedExampleReader(this.parent.iterator(), this.mapping);
    }

    @Override
    public Example getExample(int index) {
        if (index < 0 || index >= this.mapping.length) {
            throw new RuntimeException("Given index '" + index + "' does not fit the mapped ExampleSet!");
        }
        return this.parent.getExample(this.mapping[index]);
    }

    @Override
    public int size() {
        return this.mapping.length;
    }

    @Override
    public Attributes getAttributes() {
        return this.parent.getAttributes();
    }

    @Override
    public ExampleTable getExampleTable() {
        return this.parent.getExampleTable();
    }

    public static int[] createBootstrappingMapping(ExampleSet exampleSet, int size, Random random) {
        int[] mapping = new int[size];
        for (int i = 0; i < mapping.length; ++i) {
            mapping[i] = random.nextInt(exampleSet.size());
        }
        return mapping;
    }

    public static int[] createWeightedBootstrappingMapping(ExampleSet exampleSet, int size, Random random) {
        Attribute weightAttribute = exampleSet.getAttributes().getSpecial("weight");
        exampleSet.recalculateAttributeStatistics(weightAttribute);
        double maxWeight = exampleSet.getStatistics(weightAttribute, "maximum");
        int[] mapping = new int[size];
        for (int i = 0; i < mapping.length; ++i) {
            int index = -1;
            do {
                index = random.nextInt(exampleSet.size());
                Example example = exampleSet.getExample(index);
                double currentWeight = example.getValue(weightAttribute);
                if (!(random.nextDouble() > currentWeight / maxWeight)) continue;
                index = -1;
            } while (index == -1);
            mapping[i] = index;
        }
        return mapping;
    }
}

