/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.set;

import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.AbstractExampleSet;
import com.rapidminer.example.set.AcceptAllCondition;
import com.rapidminer.example.set.AttributeValueFilter;
import com.rapidminer.example.set.Condition;
import com.rapidminer.example.set.ConditionCreationException;
import com.rapidminer.example.set.CorrectPredictionCondition;
import com.rapidminer.example.set.MappedExampleReader;
import com.rapidminer.example.set.MissingAttributesCondition;
import com.rapidminer.example.set.MissingLabelsCondition;
import com.rapidminer.example.set.NoMissingAttributesCondition;
import com.rapidminer.example.set.NoMissingLabelsCondition;
import com.rapidminer.example.set.WrongPredictionCondition;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.tools.Tools;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

public class ConditionedExampleSet
extends AbstractExampleSet {
    private static final long serialVersionUID = 877488093216198777L;
    public static final String[] KNOWN_CONDITION_NAMES = new String[]{"all", "correct_predictions", "wrong_predictions", "no_missing_attributes", "missing_attributes", "no_missing_labels", "missing_labels", "attribute_value_filter"};
    public static final int CONDITION_ALL = 0;
    public static final int CONDITION_CORRECT_PREDICTIONS = 1;
    public static final int CONDITION_WRONG_PREDICTIONS = 2;
    public static final int CONDITION_NO_MISSING_ATTRIBUTES = 3;
    public static final int CONDITION_MISSING_ATTRIBUTES = 4;
    public static final int CONDITION_NO_MISSING_LABELS = 5;
    public static final int CONDITION_MISSING_LABELS = 6;
    public static final int CONDITION_ATTRIBUTE_VALUE_FILTER = 7;
    private static final String[] KNOWN_CONDITION_IMPLEMENTATIONS = new String[]{AcceptAllCondition.class.getName(), CorrectPredictionCondition.class.getName(), WrongPredictionCondition.class.getName(), NoMissingAttributesCondition.class.getName(), MissingAttributesCondition.class.getName(), NoMissingLabelsCondition.class.getName(), MissingLabelsCondition.class.getName(), AttributeValueFilter.class.getName()};
    private ExampleSet parent;
    private int[] mapping;

    public ConditionedExampleSet(ExampleSet parent, Condition condition) {
        this(parent, condition, false);
    }

    public ConditionedExampleSet(ExampleSet parent, Condition condition, boolean inverted) {
        this.parent = (ExampleSet)parent.clone();
        this.mapping = this.calculateMapping(condition, inverted);
    }

    public ConditionedExampleSet(ConditionedExampleSet exampleSet) {
        this.parent = (ExampleSet)exampleSet.parent.clone();
        this.mapping = new int[exampleSet.mapping.length];
        System.arraycopy(exampleSet.mapping, 0, this.mapping, 0, exampleSet.mapping.length);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof ConditionedExampleSet)) {
            return false;
        }
        ConditionedExampleSet other = (ConditionedExampleSet)o;
        if (this.mapping.length != other.mapping.length) {
            return false;
        }
        for (int i = 0; i < this.mapping.length; ++i) {
            if (this.mapping[i] == other.mapping[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Arrays.hashCode(this.mapping);
    }

    private int[] calculateMapping(Condition condition, boolean inverted) {
        LinkedList<Integer> indices = new LinkedList<Integer>();
        int exampleCounter = 0;
        for (Example example : this.parent) {
            if (!inverted) {
                if (condition.conditionOk(example)) {
                    indices.add(exampleCounter);
                }
            } else if (!condition.conditionOk(example)) {
                indices.add(exampleCounter);
            }
            ++exampleCounter;
        }
        int[] mapping = new int[indices.size()];
        int m = 0;
        Iterator i$ = indices.iterator();
        while (i$.hasNext()) {
            int index = (Integer)i$.next();
            mapping[m++] = index;
        }
        return mapping;
    }

    @Override
    public Iterator<Example> iterator() {
        return new MappedExampleReader(this.parent.iterator(), this.mapping);
    }

    @Override
    public Example getExample(int index) {
        if (index < 0 || index >= this.mapping.length) {
            throw new RuntimeException("Given index '" + index + "' does not fit the filtered ExampleSet!");
        }
        return this.parent.getExample(this.mapping[index]);
    }

    @Override
    public int size() {
        return this.mapping.length;
    }

    @Override
    public Attributes getAttributes() {
        return this.parent.getAttributes();
    }

    @Override
    public ExampleTable getExampleTable() {
        return this.parent.getExampleTable();
    }

    public static Condition createCondition(String name, ExampleSet exampleSet, String parameterString) throws ConditionCreationException {
        String className = name;
        for (int i = 0; i < KNOWN_CONDITION_NAMES.length; ++i) {
            if (!KNOWN_CONDITION_NAMES[i].equals(name)) continue;
            className = KNOWN_CONDITION_IMPLEMENTATIONS[i];
            break;
        }
        try {
            Class clazz = Tools.classForName(className);
            if (!Condition.class.isAssignableFrom(clazz)) {
                throw new ConditionCreationException("'" + className + "' does not implement Condition!");
            }
            Constructor constructor = clazz.getConstructor(ExampleSet.class, String.class);
            return (Condition)constructor.newInstance(exampleSet, parameterString);
        }
        catch (ClassNotFoundException e) {
            throw new ConditionCreationException("Cannot find class '" + className + "'. Check your classpath.");
        }
        catch (NoSuchMethodException e) {
            throw new ConditionCreationException("'" + className + "' must implement two argument constructor " + className + "(ExampleSet, String)!");
        }
        catch (IllegalAccessException e) {
            throw new ConditionCreationException("'" + className + "' cannot access two argument constructor " + className + "(ExampleSet, String)!");
        }
        catch (InstantiationException e) {
            throw new ConditionCreationException(className + ": cannot create condition (" + e.getMessage() + ").");
        }
        catch (Throwable e) {
            throw new ConditionCreationException(className + ": cannot invoke condition (" + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage()) + ").");
        }
    }
}

