/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.set;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableExampleSetAdapter;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeTransformation;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.AbstractExampleSet;
import com.rapidminer.example.set.AttributeTransformationWeighting;
import com.rapidminer.example.set.AttributesExampleReader;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.tools.Tools;
import java.util.Iterator;
import java.util.Random;

public class AttributeWeightedExampleSet
extends AbstractExampleSet {
    private static final long serialVersionUID = -5662936146589379273L;
    private final ExampleSet parent;
    private AttributeWeights attributeWeights = new AttributeWeights();

    protected AttributeWeightedExampleSet(ExampleSet exampleSet) {
        this(exampleSet, null);
    }

    public AttributeWeightedExampleSet(ExampleSet exampleSet, AttributeWeights weights) {
        this(exampleSet, weights, 1.0);
    }

    public AttributeWeightedExampleSet(ExampleSet exampleSet, AttributeWeights weights, double defaultWeight) {
        this.parent = (ExampleSet)exampleSet.clone();
        this.attributeWeights = weights;
        if (weights == null) {
            this.attributeWeights = new AttributeWeights();
            for (Attribute attribute : this.parent.getAttributes()) {
                this.setWeight(attribute, defaultWeight);
            }
        }
        AttributeTransformationWeighting transformation = new AttributeTransformationWeighting(this.attributeWeights);
        for (Attribute attribute : this.parent.getAttributes()) {
            if (!attribute.isNumerical()) continue;
            attribute.addTransformation(transformation);
        }
    }

    public AttributeWeightedExampleSet(AttributeWeightedExampleSet exampleSet) {
        this.parent = (ExampleSet)exampleSet.parent.clone();
        this.attributeWeights = (AttributeWeights)exampleSet.attributeWeights.clone();
        for (Attribute attribute : this.parent.getAttributes()) {
            AttributeTransformation transformation = attribute.getLastTransformation();
            if (transformation == null || !(transformation instanceof AttributeTransformationWeighting)) continue;
            ((AttributeTransformationWeighting)transformation).setAttributeWeights(this.attributeWeights);
        }
    }

    public AttributeWeights getAttributeWeights() {
        return this.attributeWeights;
    }

    public AttributeWeightedExampleSet createCleanClone() {
        AttributeWeightedExampleSet clone = (AttributeWeightedExampleSet)this.clone();
        Iterator<Attribute> a = clone.getAttributes().iterator();
        while (a.hasNext()) {
            Attribute attribute = a.next();
            double weight = this.attributeWeights.getWeight(attribute.getName());
            if (!Tools.isZero(weight)) continue;
            a.remove();
        }
        return clone;
    }

    @Override
    public Attributes getAttributes() {
        return this.parent.getAttributes();
    }

    public double getWeight(Attribute attribute) {
        if (this.attributeWeights == null) {
            return 1.0;
        }
        return this.attributeWeights.getWeight(attribute.getName());
    }

    public void setWeight(Attribute attribute, double weightValue) {
        this.attributeWeights.setWeight(attribute.getName(), weightValue);
    }

    public int getNumberOfUsedAttributes() {
        int counter = 0;
        for (Attribute attribute : this.getAttributes()) {
            if (Tools.isEqual(this.getWeight(attribute), 0.0)) continue;
            ++counter;
        }
        return counter;
    }

    public void selectAll() {
        this.setAll(1.0);
    }

    public void deselectAll() {
        this.setAll(0.0);
    }

    private void setAll(double weight) {
        for (Attribute attribute : this.getAttributes()) {
            this.setWeight(attribute, weight);
        }
    }

    public boolean isAttributeUsed(Attribute attribute) {
        return this.getWeight(attribute) != 0.0;
    }

    public void setAttributeUsed(Attribute attribute, boolean selected) {
        this.setWeight(attribute, selected ? 1.0 : 0.0);
    }

    public void flipAttributeUsed(Attribute attribute) {
        this.setWeight(attribute, this.isAttributeUsed(attribute) ? 0.0 : 1.0);
    }

    public void selectRandomSubset(int n, Random random) {
        double ratio = (double)n / (double)this.getAttributes().size();
        for (Attribute attribute : this.getAttributes()) {
            if (random.nextDouble() < ratio) {
                this.setWeight(attribute, 1.0);
                continue;
            }
            this.setWeight(attribute, 0.0);
        }
        if (this.getNumberOfUsedAttributes() == 0) {
            double probDelta = 1.0 / (double)this.getAttributes().size();
            double prob = random.nextDouble();
            double currentMax = probDelta;
            for (Attribute attribute : this.getAttributes()) {
                if (prob < currentMax) {
                    this.setWeight(attribute, 1.0);
                    break;
                }
                currentMax += probDelta;
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof AttributeWeightedExampleSet)) {
            return false;
        }
        return super.equals(o) && this.attributeWeights.equals(((AttributeWeightedExampleSet)o).attributeWeights);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.attributeWeights.hashCode();
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer(super.toString());
        buffer.append(Tools.getLineSeparator() + "Weights: ");
        int i = 0;
        for (Attribute attribute : this.getAttributes()) {
            if (i != 0) {
                buffer.append(", ");
            }
            if (i > 50) {
                buffer.append("...");
                break;
            }
            buffer.append(attribute.getName() + ":" + this.getWeight(attribute));
            ++i;
        }
        return buffer.toString();
    }

    @Override
    public DataTable createDataTable(IOContainer container) {
        return new DataTableExampleSetAdapter(this, this.getAttributeWeights());
    }

    @Override
    public Iterator<Example> iterator() {
        return new AttributesExampleReader(this.parent.iterator(), this);
    }

    @Override
    public Example getExample(int index) {
        return this.parent.getExample(index);
    }

    @Override
    public ExampleTable getExampleTable() {
        return this.parent.getExampleTable();
    }

    @Override
    public int size() {
        return this.parent.size();
    }
}

