/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.set;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.Condition;
import com.rapidminer.tools.Tools;
import java.util.HashSet;
import java.util.regex.PatternSyntaxException;

public class AttributeValueFilterSingleCondition
implements Condition {
    private static final long serialVersionUID = 1537763901048986863L;
    private static final String[] COMPARISON_TYPES = new String[]{"<=", ">=", "!=", "<>", "=", "<", ">"};
    private static final String MISSING_ENCODING = "\\?";
    public static final int LEQ = 0;
    public static final int GEQ = 1;
    public static final int NEQ1 = 2;
    public static final int NEQ2 = 3;
    public static final int EQUALS = 4;
    public static final int LESS = 5;
    public static final int GREATER = 6;
    private int comparisonType = 4;
    private Attribute attribute;
    private double numericalValue;
    private String nominalValue;
    private HashSet<Integer> allowedNominalValueIndices;
    private boolean isMissingAllowed = false;

    public AttributeValueFilterSingleCondition(Attribute attribute, int comparisonType, String value) {
        this.attribute = attribute;
        this.comparisonType = comparisonType;
        this.setValue(value);
    }

    public AttributeValueFilterSingleCondition(ExampleSet exampleSet, String parameterString) {
        if (parameterString == null || parameterString.length() == 0) {
            throw new IllegalArgumentException("Parameter string must not be empty!");
        }
        int compIndex = -1;
        this.comparisonType = 0;
        while (this.comparisonType < COMPARISON_TYPES.length && (compIndex = parameterString.indexOf(COMPARISON_TYPES[this.comparisonType])) == -1) {
            ++this.comparisonType;
        }
        if (compIndex == -1) {
            throw new IllegalArgumentException("Parameter string must have the form 'attribute {=|<|>|<=|>=|!=} value'");
        }
        String attName = parameterString.substring(0, compIndex).trim();
        String valueStr = parameterString.substring(compIndex + COMPARISON_TYPES[this.comparisonType].length()).trim();
        if (attName.length() == 0 || valueStr.length() == 0) {
            throw new IllegalArgumentException("Parameter string must have the form 'attribute {=|<|>|<=|>=|!=} value'");
        }
        this.attribute = exampleSet.getAttributes().get(attName);
        if (this.attribute == null) {
            throw new IllegalArgumentException("Unknown attribute: '" + attName + "'");
        }
        this.setValue(valueStr);
    }

    private void setValue(String value) {
        if (this.attribute.isNominal()) {
            if (this.comparisonType != 4 && this.comparisonType != 2 && this.comparisonType != 3) {
                throw new IllegalArgumentException("For nominal attributes only '=' and '!=' or '<>' is allowed!");
            }
            this.nominalValue = value;
            this.isMissingAllowed = this.nominalValue.equals(MISSING_ENCODING);
            this.allowedNominalValueIndices = new HashSet(this.attribute.getMapping().size());
            for (String attributeValue : this.attribute.getMapping().getValues()) {
                try {
                    if (!attributeValue.equals(this.nominalValue) && !attributeValue.matches(this.nominalValue)) continue;
                    this.allowedNominalValueIndices.add(this.attribute.getMapping().mapString(attributeValue));
                }
                catch (PatternSyntaxException e) {}
            }
        } else if (value.equals("?")) {
            this.numericalValue = Double.NaN;
        } else {
            try {
                this.numericalValue = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Value for attribute '" + this.attribute.getName() + "' must be numerical!");
            }
        }
    }

    @Override
    @Deprecated
    public Condition duplicate() {
        return this;
    }

    public String toString() {
        return this.attribute.getName() + " " + COMPARISON_TYPES[this.comparisonType] + " " + (this.attribute.isNominal() ? this.nominalValue : "" + this.numericalValue);
    }

    @Override
    public boolean conditionOk(Example e) {
        if (this.attribute.isNominal()) {
            double doubleValue = e.getValue(this.attribute);
            if (Double.isNaN(doubleValue)) {
                switch (this.comparisonType) {
                    case 2: 
                    case 3: {
                        return !this.isMissingAllowed;
                    }
                    case 4: {
                        return this.isMissingAllowed;
                    }
                }
                return false;
            }
            int value = (int)doubleValue;
            switch (this.comparisonType) {
                case 2: 
                case 3: {
                    return !this.allowedNominalValueIndices.contains(value);
                }
                case 4: {
                    return this.allowedNominalValueIndices.contains(value);
                }
            }
            return false;
        }
        switch (this.comparisonType) {
            case 0: {
                return Tools.isLessEqual(e.getNumericalValue(this.attribute), this.numericalValue);
            }
            case 1: {
                return Tools.isGreaterEqual(e.getNumericalValue(this.attribute), this.numericalValue);
            }
            case 2: 
            case 3: {
                return Tools.isNotEqual(e.getNumericalValue(this.attribute), this.numericalValue);
            }
            case 4: {
                return Tools.isEqual(e.getNumericalValue(this.attribute), this.numericalValue);
            }
            case 5: {
                return Tools.isLess(e.getNumericalValue(this.attribute), this.numericalValue);
            }
            case 6: {
                return Tools.isGreater(e.getNumericalValue(this.attribute), this.numericalValue);
            }
        }
        return false;
    }
}

