/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.set;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeTransformation;
import com.rapidminer.example.AttributeWeights;

public class AttributeTransformationWeighting
implements AttributeTransformation {
    private static final long serialVersionUID = 1L;
    private AttributeWeights attributeWeights;

    public AttributeTransformationWeighting(AttributeWeights attributeWeights) {
        this.setAttributeWeights(attributeWeights);
    }

    public AttributeTransformationWeighting(AttributeTransformationWeighting other) {
        this.attributeWeights = other.attributeWeights;
    }

    @Override
    public Object clone() {
        return new AttributeTransformationWeighting(this);
    }

    public void setAttributeWeights(AttributeWeights weights) {
        this.attributeWeights = weights;
    }

    @Override
    public double inverseTransform(Attribute attribute, double value) {
        double weight = this.attributeWeights.getWeight(attribute.getName());
        if (!Double.isNaN(weight)) {
            return value / weight;
        }
        return value;
    }

    @Override
    public boolean isReversable() {
        return true;
    }

    @Override
    public double transform(Attribute attribute, double value) {
        double weight = this.attributeWeights.getWeight(attribute.getName());
        if (!Double.isNaN(weight)) {
            return value * weight;
        }
        return value;
    }
}

