/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.set;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeTransformation;
import java.util.HashMap;
import java.util.Map;

public class AttributeTransformationReplaceMissing
implements AttributeTransformation {
    private static final long serialVersionUID = 1L;
    private Map<String, Double> replacementMap;

    public AttributeTransformationReplaceMissing(Map<String, Double> replacementMap) {
        this.replacementMap = replacementMap;
    }

    public AttributeTransformationReplaceMissing(AttributeTransformationReplaceMissing other) {
        this.replacementMap = new HashMap<String, Double>();
        for (Map.Entry<String, Double> entry : other.replacementMap.entrySet()) {
            this.replacementMap.put(entry.getKey(), (double)entry.getValue());
        }
    }

    @Override
    public Object clone() {
        return new AttributeTransformationReplaceMissing(this);
    }

    public void setReplacementMap(Map<String, Double> replacementMap) {
        this.replacementMap = replacementMap;
    }

    @Override
    public double inverseTransform(Attribute attribute, double value) {
        return value;
    }

    @Override
    public boolean isReversable() {
        return false;
    }

    @Override
    public double transform(Attribute attribute, double value) {
        if (Double.isNaN(value)) {
            Double replacement = this.replacementMap.get(attribute.getName());
            if (replacement != null) {
                return replacement;
            }
            return value;
        }
        return value;
    }
}

