/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.set;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.AbstractExampleSet;
import com.rapidminer.example.set.AttributesExampleReader;
import com.rapidminer.example.table.ExampleTable;
import java.util.Iterator;

public class AttributeSelectionExampleSet
extends AbstractExampleSet {
    private static final long serialVersionUID = 7946137859300860625L;
    private ExampleSet parent;

    public AttributeSelectionExampleSet(ExampleSet exampleSet, boolean[] selectionMask) {
        this.parent = (ExampleSet)exampleSet.clone();
        if (selectionMask != null) {
            if (selectionMask.length != exampleSet.getAttributes().size()) {
                throw new IllegalArgumentException("Length of the selection mask must be equal to the parent's number of attributes.");
            }
            int counter = 0;
            Iterator<Attribute> i = this.parent.getAttributes().iterator();
            while (i.hasNext()) {
                i.next();
                if (!selectionMask[counter]) {
                    i.remove();
                }
                ++counter;
            }
        }
    }

    public AttributeSelectionExampleSet(AttributeSelectionExampleSet exampleSet) {
        this.parent = (ExampleSet)exampleSet.parent.clone();
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof AttributeSelectionExampleSet)) {
            return false;
        }
        return ((Object)this.parent).equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ ((Object)this.parent).hashCode();
    }

    @Override
    public Attributes getAttributes() {
        return this.parent.getAttributes();
    }

    @Override
    public Iterator<Example> iterator() {
        return new AttributesExampleReader(this.parent.iterator(), this);
    }

    @Override
    public Example getExample(int index) {
        return this.parent.getExample(index);
    }

    @Override
    public ExampleTable getExampleTable() {
        return this.parent.getExampleTable();
    }

    @Override
    public int size() {
        return this.parent.size();
    }
}

