/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.set;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableExampleSetAdapter;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Statistics;
import com.rapidminer.io.process.XMLTools;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.ResultObjectAdapter;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.XMLException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractExampleSet
extends ResultObjectAdapter
implements ExampleSet {
    private static final long serialVersionUID = 8596141056047402798L;
    private final Map<String, List<Statistics>> statisticsMap = new HashMap<String, List<Statistics>>();
    private Map<Double, int[]> idMap = new HashMap<Double, int[]>();

    @Override
    public String getName() {
        return "ExampleSet";
    }

    @Override
    public Example getExampleFromId(double id) {
        int[] indices = this.idMap.get(id);
        if (indices != null && indices.length > 0) {
            return this.getExample(indices[0]);
        }
        return null;
    }

    @Override
    public int[] getExampleIndicesFromId(double id) {
        return this.idMap.get(id);
    }

    public String toString() {
        StringBuffer str = new StringBuffer(this.getClass().getSimpleName() + ":" + Tools.getLineSeparator());
        str.append(this.size() + " examples," + Tools.getLineSeparator());
        str.append(this.getAttributes().size() + " regular attributes," + Tools.getLineSeparator());
        boolean first = true;
        Iterator<AttributeRole> s = this.getAttributes().specialAttributes();
        while (s.hasNext()) {
            if (first) {
                str.append("special attributes = {" + Tools.getLineSeparator());
                first = false;
            }
            AttributeRole special = s.next();
            str.append("    " + special.getSpecialName() + " = " + special.getAttribute() + Tools.getLineSeparator());
        }
        if (!first) {
            str.append("}");
        } else {
            str.append("no special attributes" + Tools.getLineSeparator());
        }
        return str.toString();
    }

    public DataTable createDataTable(IOContainer container) {
        AttributeWeights weights = null;
        if (container != null) {
            try {
                weights = container.get(AttributeWeights.class);
                for (Attribute attribute : this.getAttributes()) {
                    double weight = weights.getWeight(attribute.getName());
                    if (!Double.isNaN(weight)) continue;
                    weights = null;
                    break;
                }
            }
            catch (MissingIOObjectException missingIOObjectException) {
                // empty catch block
            }
        }
        return new DataTableExampleSetAdapter(this, weights);
    }

    @Override
    public void writeDataFile(File dataFile, int fractionDigits, boolean quoteNominal, boolean zipped, boolean append, Charset encoding) throws IOException {
        PrintWriter out = null;
        OutputStream outStream = null;
        try {
            outStream = zipped ? new GZIPOutputStream(new FileOutputStream(dataFile, append)) : new FileOutputStream(dataFile, append);
            out = new PrintWriter(new OutputStreamWriter(outStream, encoding));
            Iterator reader = this.iterator();
            while (reader.hasNext()) {
                out.println(((Example)reader.next()).toDenseString(fractionDigits, quoteNominal));
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (outStream != null) {
                outStream.close();
            }
        }
    }

    @Override
    public void writeSparseDataFile(File dataFile, int format, int fractionDigits, boolean quoteNominal, boolean zipped, boolean append, Charset encoding) throws IOException {
        PrintWriter out = null;
        OutputStream outStream = null;
        try {
            outStream = zipped ? new GZIPOutputStream(new FileOutputStream(dataFile, append)) : new FileOutputStream(dataFile, append);
            out = new PrintWriter(new OutputStreamWriter(outStream, encoding));
            Iterator reader = this.iterator();
            while (reader.hasNext()) {
                out.println(((Example)reader.next()).toSparseString(format, fractionDigits, quoteNominal));
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (outStream != null) {
                outStream.close();
            }
        }
    }

    @Override
    public void writeAttributeFile(File attFile, File dataFile, Charset encoding) throws IOException {
        if (dataFile == null) {
            throw new IOException("ExampleSet writing: cannot determine path to data file: data file was not given!");
        }
        String relativePath = Tools.getRelativePath(dataFile, attFile);
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = document.createElement("attributeset");
            root.setAttribute("default_source", relativePath);
            root.setAttribute("encoding", encoding.name());
            document.appendChild(root);
            int sourcecol = 1;
            Iterator<AttributeRole> i = this.getAttributes().allAttributeRoles();
            while (i.hasNext()) {
                root.appendChild(this.writeAttributeMetaData(i.next(), sourcecol, document, false));
                ++sourcecol;
            }
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(attFile), encoding));
            writer.print(XMLTools.toString(document, encoding));
            writer.close();
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Cannot create XML document builder: " + e, e);
        }
        catch (XMLException e) {
            throw new IOException("Could not format XML document:" + e, e);
        }
    }

    @Override
    public void writeSparseAttributeFile(File attFile, File dataFile, int format, Charset encoding) throws IOException {
        if (dataFile == null) {
            throw new IOException("ExampleSet sparse writing: cannot determine path to data file: data file was not given!");
        }
        String relativePath = Tools.getRelativePath(dataFile, attFile);
        try {
            AttributeRole weightRole;
            AttributeRole idRole;
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = document.createElement("attributeset");
            root.setAttribute("default_source", relativePath);
            root.setAttribute("encoding", encoding.name());
            document.appendChild(root);
            AttributeRole labelRole = this.getAttributes().getRole("label");
            if (labelRole != null && format != 4) {
                root.appendChild(this.writeAttributeMetaData(labelRole, 0, document, true));
            }
            if ((idRole = this.getAttributes().getRole("id")) != null) {
                root.appendChild(this.writeAttributeMetaData(idRole, 0, document, true));
            }
            if ((weightRole = this.getAttributes().getRole("weight")) != null) {
                root.appendChild(this.writeAttributeMetaData(weightRole, 0, document, true));
            }
            int sourcecol = 1;
            for (Attribute attribute : this.getAttributes()) {
                root.appendChild(this.writeAttributeMetaData("attribute", attribute, sourcecol, document, false));
                ++sourcecol;
            }
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(attFile), encoding));
            writer.print(XMLTools.toString(document, encoding));
            writer.close();
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Cannot create XML document builder: " + e, e);
        }
        catch (XMLException e) {
            throw new IOException("Could not format XML document:" + e, e);
        }
    }

    private Element writeAttributeMetaData(AttributeRole attributeRole, int sourcecol, Document document, boolean sparse) {
        String tag = "attribute";
        if (attributeRole.isSpecial()) {
            tag = attributeRole.getSpecialName();
        }
        Attribute attribute = attributeRole.getAttribute();
        return this.writeAttributeMetaData(tag, attribute, sourcecol, document, sparse);
    }

    private Element writeAttributeMetaData(String tag, Attribute attribute, int sourcecol, Document document, boolean sparse) {
        Element attributeElement = document.createElement(tag);
        attributeElement.setAttribute("name", attribute.getName());
        if (!sparse || tag.equals("attribute")) {
            attributeElement.setAttribute("sourcecol", sourcecol + "");
        }
        attributeElement.setAttribute("valuetype", Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(attribute.getValueType()));
        if (!Ontology.ATTRIBUTE_BLOCK_TYPE.isA(attribute.getBlockType(), 1)) {
            attributeElement.setAttribute("blocktype", Ontology.ATTRIBUTE_BLOCK_TYPE.mapIndex(attribute.getBlockType()));
        }
        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 1) && !tag.equals(Attributes.KNOWN_ATTRIBUTE_TYPES[2])) {
            for (String nominalValue : attribute.getMapping().getValues()) {
                Element valueElement = document.createElement("value");
                valueElement.setTextContent(nominalValue);
                attributeElement.appendChild(valueElement);
            }
        }
        return attributeElement;
    }

    public String getExtension() {
        return "aml";
    }

    public String getFileDescription() {
        return "attribute description file";
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ExampleSet)) {
            return false;
        }
        ExampleSet es = (ExampleSet)o;
        return ((Object)this.getAttributes()).equals(es.getAttributes());
    }

    @Override
    public int hashCode() {
        return ((Object)this.getAttributes()).hashCode();
    }

    @Override
    public IOObject copy() {
        return (IOObject)this.clone();
    }

    @Override
    public Object clone() {
        try {
            Class<?> clazz = this.getClass();
            Constructor<?> cloneConstructor = clazz.getConstructor(clazz);
            AbstractExampleSet result = (AbstractExampleSet)cloneConstructor.newInstance(this);
            result.idMap = this.idMap;
            return result;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot clone ExampleSet: " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("'" + this.getClass().getName() + "' does not implement clone constructor!");
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Cannot clone " + this.getClass().getName() + ": " + e + ". Target: " + e.getTargetException() + ". Cause: " + e.getCause() + ".");
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Cannot clone " + this.getClass().getName() + ": " + e);
        }
    }

    @Override
    public void remapIds() {
        this.idMap = new HashMap<Double, int[]>(this.size());
        Attribute idAttribute = this.getAttributes().getSpecial("id");
        if (idAttribute != null) {
            int index = 0;
            for (Example example : this) {
                double value = example.getValue(idAttribute);
                if (!Double.isNaN(value)) {
                    if (this.idMap.containsKey(value)) {
                        int[] indices = this.idMap.get(value);
                        int[] newIndices = new int[indices.length + 1];
                        for (int i = 0; i < indices.length; ++i) {
                            newIndices[i] = indices[i];
                        }
                        newIndices[newIndices.length - 1] = index;
                        this.idMap.put(value, newIndices);
                    } else {
                        this.idMap.put(value, new int[]{index});
                    }
                }
                ++index;
            }
        }
    }

    @Override
    public void recalculateAllAttributeStatistics() {
        ArrayList<Attribute> allAttributes = new ArrayList<Attribute>();
        Iterator<Attribute> a = this.getAttributes().allAttributes();
        while (a.hasNext()) {
            allAttributes.add(a.next());
        }
        this.recalculateAttributeStatistics(allAttributes);
    }

    @Override
    public void recalculateAttributeStatistics(Attribute attribute) {
        ArrayList<Attribute> allAttributes = new ArrayList<Attribute>();
        allAttributes.add(attribute);
        this.recalculateAttributeStatistics(allAttributes);
    }

    private void recalculateAttributeStatistics(List<Attribute> attributeList) {
        if (attributeList.size() == 0) {
            return;
        }
        for (Attribute attribute : attributeList) {
            Iterator<Statistics> stats = attribute.getAllStatistics();
            while (stats.hasNext()) {
                Statistics statistics = stats.next();
                statistics.startCounting(attribute);
            }
        }
        Attribute weightAttribute = this.getAttributes().getWeight();
        if (weightAttribute != null && !weightAttribute.isNumerical()) {
            weightAttribute = null;
        }
        for (Example example : this) {
            for (Attribute attribute : attributeList) {
                double value = example.getValue(attribute);
                double weight = 1.0;
                if (weightAttribute != null) {
                    weight = example.getValue(weightAttribute);
                }
                Iterator<Statistics> stats = attribute.getAllStatistics();
                while (stats.hasNext()) {
                    Statistics statistics = stats.next();
                    statistics.count(value, weight);
                }
            }
        }
        for (Attribute attribute : attributeList) {
            List<Statistics> statisticsList = this.statisticsMap.get(attribute.getName());
            if (statisticsList == null) {
                statisticsList = new LinkedList<Statistics>();
                this.statisticsMap.put(attribute.getName(), statisticsList);
            }
            statisticsList.clear();
            Iterator<Statistics> stats = attribute.getAllStatistics();
            while (stats.hasNext()) {
                Statistics statistics = (Statistics)stats.next().clone();
                statisticsList.add(statistics);
            }
        }
    }

    @Override
    public double getStatistics(Attribute attribute, String statisticsName) {
        return this.getStatistics(attribute, statisticsName, null);
    }

    @Override
    public double getStatistics(Attribute attribute, String statisticsName, String statisticsParameter) {
        List<Statistics> statisticsList = this.statisticsMap.get(attribute.getName());
        if (statisticsList == null) {
            return Double.NaN;
        }
        for (Statistics statistics : statisticsList) {
            if (!statistics.handleStatistics(statisticsName)) continue;
            return statistics.getStatistics(attribute, statisticsName, statisticsParameter);
        }
        return Double.NaN;
    }
}

