/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Statistics;
import com.rapidminer.tools.LogService;

public class WeightedNumericalStatistics
implements Statistics {
    private static final long serialVersionUID = -6283236022093847887L;
    private double sum = 0.0;
    private double squaredSum = 0.0;
    private double totalWeight = 0.0;
    private double count = 0.0;

    public WeightedNumericalStatistics() {
    }

    private WeightedNumericalStatistics(WeightedNumericalStatistics other) {
        this.sum = other.sum;
        this.squaredSum = other.squaredSum;
        this.totalWeight = other.totalWeight;
        this.count = other.count;
    }

    @Override
    public Object clone() {
        return new WeightedNumericalStatistics(this);
    }

    @Override
    public void startCounting(Attribute attribute) {
        this.sum = 0.0;
        this.squaredSum = 0.0;
        this.totalWeight = 0.0;
        this.count = 0.0;
    }

    @Override
    public void count(double value, double weight) {
        if (Double.isNaN(weight)) {
            weight = 1.0;
        }
        if (!Double.isNaN(value)) {
            this.sum += weight * value;
            this.squaredSum += weight * value * value;
            this.totalWeight += weight;
            this.count += 1.0;
        }
    }

    @Override
    public boolean handleStatistics(String name) {
        return "average_weighted".equals(name) || "variance_weighted".equals(name) || "sum_weighted".equals(name);
    }

    @Override
    public double getStatistics(Attribute attribute, String name, String parameter) {
        if ("average_weighted".equals(name)) {
            return this.sum / this.totalWeight;
        }
        if ("variance_weighted".equals(name)) {
            if (this.count <= 1.0) {
                return 0.0;
            }
            return (this.squaredSum - this.sum * this.sum / this.totalWeight) / ((this.count - 1.0) / this.count * this.totalWeight);
        }
        if ("sum_weighted".equals(name)) {
            return this.sum;
        }
        LogService.getGlobal().log("Cannot calculate statistics, unknown type: " + name, 5);
        return Double.NaN;
    }
}

