/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Statistics;
import com.rapidminer.tools.LogService;

public class UnknownStatistics
implements Statistics {
    private static final long serialVersionUID = 217609774484151520L;
    private int unknownCounter = 0;

    public UnknownStatistics() {
    }

    private UnknownStatistics(UnknownStatistics other) {
        this.unknownCounter = other.unknownCounter;
    }

    @Override
    public Object clone() {
        return new UnknownStatistics(this);
    }

    @Override
    public void startCounting(Attribute attribute) {
        this.unknownCounter = 0;
    }

    @Override
    public void count(double value, double weight) {
        if (Double.isNaN(value)) {
            ++this.unknownCounter;
        }
    }

    @Override
    public double getStatistics(Attribute attribute, String statisticsName, String parameter) {
        if ("unknown".equals(statisticsName)) {
            return this.unknownCounter;
        }
        LogService.getGlobal().log("Cannot calculate statistics, unknown type: " + statisticsName, 5);
        return Double.NaN;
    }

    @Override
    public boolean handleStatistics(String statisticsName) {
        return "unknown".equals(statisticsName);
    }

    public String toString() {
        return "unknown: " + this.unknownCounter;
    }
}

