/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.AttributeWeightedExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.example.table.NominalMapping;
import com.rapidminer.generator.FeatureGenerator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.preprocessing.IdTagging;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.sampling.OrderedSamplingWithoutReplacement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class Tools {
    public static String[] getAllAttributeNames(ExampleSet exampleSet) {
        String[] attributeNames = new String[exampleSet.getAttributes().allSize()];
        int counter = 0;
        Iterator<Attribute> a = exampleSet.getAttributes().allAttributes();
        while (a.hasNext()) {
            Attribute attribute = a.next();
            attributeNames[counter++] = attribute.getName();
        }
        return attributeNames;
    }

    public static String[] getRegularAttributeNames(ExampleSet exampleSet) {
        String[] attributeNames = new String[exampleSet.getAttributes().size()];
        int counter = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            attributeNames[counter++] = attribute.getName();
        }
        return attributeNames;
    }

    public static String[] getRegularAttributeConstructions(ExampleSet exampleSet) {
        String[] attributeNames = new String[exampleSet.getAttributes().size()];
        int counter = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!attribute.getConstruction().equals(attribute.getName()) && !attribute.getConstruction().startsWith("gens")) {
                attributeNames[counter++] = attribute.getConstruction();
                continue;
            }
            attributeNames[counter++] = attribute.getName();
        }
        return attributeNames;
    }

    public static Attribute[] createRegularAttributeArray(ExampleSet exampleSet) {
        Attribute[] attributes = new Attribute[exampleSet.getAttributes().size()];
        int counter = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            attributes[counter++] = attribute;
        }
        return attributes;
    }

    public static Attribute[] getRandomCompatibleAttributes(ExampleSet exampleSet, FeatureGenerator generator, String[] functions, Random random) {
        List<Attribute[]> inputAttributes = generator.getInputCandidates(exampleSet, functions);
        if (inputAttributes.size() > 0) {
            return inputAttributes.get(random.nextInt(inputAttributes.size()));
        }
        return null;
    }

    public static Attribute[] getWeightedCompatibleAttributes(AttributeWeightedExampleSet exampleSet, FeatureGenerator generator, String[] functions, RandomGenerator random) {
        List<Attribute[]> inputAttributes = generator.getInputCandidates(exampleSet, functions);
        double[] probs = new double[inputAttributes.size()];
        double probSum = 0.0;
        Iterator<Attribute[]> i = inputAttributes.iterator();
        int k = 0;
        while (i.hasNext()) {
            Attribute[] candidate = i.next();
            for (int j = 0; j < candidate.length; ++j) {
                double weight = exampleSet.getWeight(candidate[j]);
                probSum += weight;
                probs[k] = weight;
            }
        }
        int j = 0;
        while (j < probs.length) {
            int n = j++;
            probs[n] = probs[n] / probSum;
        }
        return inputAttributes.get(random.randomIndex(probs));
    }

    public static Attribute createSpecialAttribute(ExampleSet exampleSet, String name, int valueType) {
        Attribute attribute = AttributeFactory.createAttribute(name, valueType);
        exampleSet.getExampleTable().addAttribute(attribute);
        exampleSet.getAttributes().setSpecialAttribute(attribute, name);
        return attribute;
    }

    public static AttributeMetaData createWeightAttributeMetaData(ExampleSetMetaData emd) {
        return new AttributeMetaData("weight", 4, "weight");
    }

    public static Attribute createWeightAttribute(ExampleSet exampleSet) {
        Attribute weight = exampleSet.getAttributes().getWeight();
        if (weight != null) {
            exampleSet.getLog().logWarning("ExampleSet.createWeightAttribute(): Overwriting old weight attribute!");
        }
        weight = AttributeFactory.createAttribute("weight", 4);
        exampleSet.getExampleTable().addAttribute(weight);
        exampleSet.getAttributes().setWeight(weight);
        for (Example example : exampleSet) {
            example.setValue(weight, 1.0);
        }
        return weight;
    }

    public static boolean containsValueType(ExampleSet exampleSet, int valueType) {
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), valueType)) continue;
            return true;
        }
        return false;
    }

    public static void replaceValue(Attribute attribute, String oldValue, String newValue) {
        if (!attribute.isNominal()) {
            throw new RuntimeException("Example-Tools: replaceValue is only supported for nominal attributes.");
        }
        NominalMapping mapping = attribute.getMapping();
        int oldIndex = mapping.getIndex(oldValue);
        if (oldIndex < 0) {
            throw new RuntimeException("Example-Tools: replaceValue cannot be performed since old value was not defined in the attribute.");
        }
        mapping.setMapping(newValue, oldIndex);
    }

    public static void replaceValue(ExampleSet exampleSet, Attribute attribute, String oldValue, String newValue) {
        if (!attribute.isNominal()) {
            throw new RuntimeException("Example-Tools: replaceValue is only supported for nominal attributes.");
        }
        NominalMapping mapping = attribute.getMapping();
        if (oldValue.equals("?")) {
            for (Example example : exampleSet) {
                if (!Double.isNaN(example.getValue(attribute))) continue;
                example.setValue(attribute, mapping.mapString(newValue));
            }
        } else {
            int oldIndex = mapping.getIndex(oldValue);
            if (oldIndex < 0) {
                throw new RuntimeException("Example-Tools: replaceValue cannot be performed since old value was not defined in the attribute.");
            }
            if (newValue.equals("?")) {
                for (Example example : exampleSet) {
                    int index = mapping.getIndex(example.getValueAsString(attribute));
                    if (index != oldIndex) continue;
                    example.setValue(attribute, Double.NaN);
                }
                return;
            }
            int newIndex = mapping.getIndex(newValue);
            if (newIndex >= 0) {
                for (Example example : exampleSet) {
                    int index = mapping.getIndex(example.getValueAsString(attribute));
                    if (index != oldIndex) continue;
                    example.setValue(attribute, newIndex);
                }
            } else {
                mapping.setMapping(newValue, oldIndex);
            }
        }
    }

    public static void replaceValue(ExampleSet exampleSet, Attribute attribute, double oldValue, double newValue) {
        for (Example example : exampleSet) {
            double value = example.getValue(attribute);
            if (Double.isNaN(oldValue) && Double.isNaN(value)) {
                example.setValue(attribute, newValue);
                continue;
            }
            if (!com.rapidminer.tools.Tools.isEqual(value, oldValue)) continue;
            example.setValue(attribute, newValue);
        }
    }

    public static boolean compatible(Attribute first, Attribute second) {
        return Ontology.ATTRIBUTE_VALUE_TYPE.isA(first.getValueType(), second.getValueType()) && Ontology.ATTRIBUTE_BLOCK_TYPE.isA(first.getBlockType(), second.getBlockType());
    }

    public static double getAverageWeight(AttributeWeightedExampleSet exampleSet) {
        int counter = 0;
        double weightSum = 0.0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            double weight = exampleSet.getWeight(attribute);
            if (Double.isNaN(weight)) continue;
            weightSum += Math.abs(weight);
            ++counter;
        }
        return weightSum / (double)counter;
    }

    public static double[] getProbabilitiesFromWeights(Attribute[] attributes, AttributeWeightedExampleSet exampleSet) {
        return Tools.getProbabilitiesFromWeights(attributes, exampleSet, false);
    }

    public static double[] getInverseProbabilitiesFromWeights(Attribute[] attributes, AttributeWeightedExampleSet exampleSet) {
        return Tools.getProbabilitiesFromWeights(attributes, exampleSet, true);
    }

    public static double[] getProbabilitiesFromWeights(Attribute[] attributes, AttributeWeightedExampleSet exampleSet, boolean inverse) {
        double weightSum = 0.0;
        int counter = 0;
        for (int i = 0; i < attributes.length; ++i) {
            double weight = exampleSet.getWeight(attributes[i]);
            if (Double.isNaN(weight)) continue;
            weightSum += Math.abs(weight);
            ++counter;
        }
        double weightAverage = weightSum / (double)counter;
        weightSum += (double)(attributes.length - counter) * weightAverage;
        double[] probs = new double[attributes.length];
        for (int i = 0; i < probs.length; ++i) {
            double weight = exampleSet.getWeight(attributes[i]);
            probs[i] = Double.isNaN(weight) ? weightAverage / weightSum : (inverse ? (2.0 * weightAverage - Math.abs(weight)) / weightSum : Math.abs(weight) / weightSum);
        }
        return probs;
    }

    public static Attribute selectAttribute(Attribute[] attributes, double[] probs, Random random) {
        double r = random.nextDouble();
        double sum = 0.0;
        for (int i = 0; i < attributes.length; ++i) {
            if (!(r < (sum += probs[i]))) continue;
            return attributes[i];
        }
        return attributes[attributes.length - 1];
    }

    public static boolean isDefault(double defaultValue, double value) {
        if (Double.isNaN(defaultValue)) {
            return Double.isNaN(value);
        }
        return defaultValue == value;
    }

    public static void onlyNonMissingValues(ExampleSet exampleSet, String task) throws OperatorException {
        exampleSet.recalculateAllAttributeStatistics();
        for (Attribute attribute : exampleSet.getAttributes()) {
            double missing = exampleSet.getStatistics(attribute, "unknown");
            if (!(missing > 0.0)) continue;
            throw new UserError(null, 139, task);
        }
    }

    public static void onlyNumericalAttributes(ExampleSet es, String task) throws OperatorException {
        for (Attribute attribute : es.getAttributes()) {
            if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 2)) continue;
            throw new UserError(null, 104, task, attribute.getName());
        }
    }

    public static void onlyNominalAttributes(ExampleSet es, String task) throws OperatorException {
        for (Attribute attribute : es.getAttributes()) {
            if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 1)) continue;
            throw new UserError(null, 103, task, attribute.getName());
        }
    }

    public static void isLabelled(ExampleSet es) throws OperatorException {
        if (es.getAttributes().getLabel() == null) {
            throw new UserError(null, 105);
        }
    }

    public static void isIdTagged(ExampleSet es) throws OperatorException {
        if (es.getAttributes().getId() == null) {
            throw new UserError(null, 129);
        }
    }

    public static void checkAndCreateIds(ExampleSet es) throws OperatorException {
        if (es.getAttributes().getId() == null) {
            try {
                IdTagging idTagging = OperatorService.createOperator(IdTagging.class);
                idTagging.apply(es);
            }
            catch (OperatorCreationException e) {
                throw new UserError(null, 129);
            }
        }
    }

    public static void checkIds(ExampleSet exampleSet) throws UserError {
        if (exampleSet.getAttributes().getId() == null) {
            throw new UserError(null, 129);
        }
    }

    public static void hasNominalLabels(ExampleSet es) throws OperatorException {
        Tools.isLabelled(es);
        Attribute a = es.getAttributes().getLabel();
        if (!Ontology.ATTRIBUTE_VALUE_TYPE.isA(a.getValueType(), 1)) {
            throw new UserError(null, 101, "clustering", a.getName());
        }
    }

    public static void isNonEmpty(ExampleSet es) throws OperatorException {
        if (es.size() == 0) {
            throw new UserError(null, 117);
        }
    }

    public static ExampleSet getLinearSubsetCopy(ExampleSet exampleSet, int size, int offset) {
        HashMap<Attribute, String> specialMap = new HashMap<Attribute, String>();
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        Iterator<AttributeRole> a = exampleSet.getAttributes().allAttributeRoles();
        while (a.hasNext()) {
            AttributeRole role = a.next();
            Attribute clone = (Attribute)role.getAttribute().clone();
            attributes.add(clone);
            if (!role.isSpecial()) continue;
            specialMap.put(clone, role.getSpecialName());
        }
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        int maxSize = exampleSet.size();
        for (int i = offset; i < offset + size && i < maxSize; ++i) {
            Example example = exampleSet.getExample(i);
            Iterator<Attribute> allI = exampleSet.getAttributes().allAttributes();
            int counter = 0;
            double[] dataRow = new double[attributes.size()];
            while (allI.hasNext()) {
                dataRow[counter++] = example.getValue(allI.next());
            }
            table.addDataRow(new DoubleArrayDataRow(dataRow));
        }
        return table.createExampleSet(specialMap);
    }

    public static ExampleSet getShuffledSubsetCopy(ExampleSet exampleSet, int size, RandomGenerator randomGenerator) {
        int[] selectedIndices = OrderedSamplingWithoutReplacement.getSampledIndices(randomGenerator, exampleSet.size(), size);
        HashMap<Attribute, String> specialMap = new HashMap<Attribute, String>();
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        Iterator<AttributeRole> a = exampleSet.getAttributes().allAttributeRoles();
        while (a.hasNext()) {
            AttributeRole role = a.next();
            Attribute clone = (Attribute)role.getAttribute().clone();
            attributes.add(clone);
            if (!role.isSpecial()) continue;
            specialMap.put(clone, role.getSpecialName());
        }
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        for (int i = 0; i < selectedIndices.length; ++i) {
            Example example = exampleSet.getExample(selectedIndices[i]);
            Iterator<Attribute> allI = exampleSet.getAttributes().allAttributes();
            int counter = 0;
            double[] dataRow = new double[attributes.size()];
            while (allI.hasNext()) {
                dataRow[counter++] = example.getValue(allI.next());
            }
            table.addDataRow(new DoubleArrayDataRow(dataRow));
        }
        return table.createExampleSet(specialMap);
    }
}

