/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example;

import com.rapidminer.example.AbstractAttributes;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class SimpleAttributes
extends AbstractAttributes {
    private static final long serialVersionUID = 6388263725741578818L;
    private List<AttributeRole> attributes = new LinkedList<AttributeRole>();
    private transient Map<String, AttributeRole> nameToAttributeRoleMap = new HashMap<String, AttributeRole>();
    private transient Map<String, AttributeRole> specialNameToAttributeRoleMap = new HashMap<String, AttributeRole>();

    public SimpleAttributes() {
    }

    private SimpleAttributes(SimpleAttributes attributes) {
        for (AttributeRole role : attributes.attributes) {
            this.register((AttributeRole)role.clone(), false);
        }
    }

    public Object readResolve() {
        if (this.nameToAttributeRoleMap == null) {
            this.nameToAttributeRoleMap = new HashMap<String, AttributeRole>();
            this.specialNameToAttributeRoleMap = new HashMap<String, AttributeRole>();
            for (AttributeRole attributeRole : this.attributes) {
                this.register(attributeRole, true);
            }
        }
        return this;
    }

    @Override
    public Object clone() {
        return new SimpleAttributes(this);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof SimpleAttributes)) {
            return false;
        }
        SimpleAttributes other = (SimpleAttributes)o;
        return ((Object)this.attributes).equals(other.attributes);
    }

    @Override
    public int hashCode() {
        return ((Object)this.attributes).hashCode();
    }

    @Override
    public Iterator<AttributeRole> allAttributeRoles() {
        final Iterator<AttributeRole> i = this.attributes.iterator();
        return new Iterator<AttributeRole>(){
            private AttributeRole current;

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public AttributeRole next() {
                this.current = (AttributeRole)i.next();
                return this.current;
            }

            @Override
            public void remove() {
                i.remove();
                SimpleAttributes.this.unregister(this.current, true);
            }
        };
    }

    private void register(AttributeRole attributeRole, boolean onlyMaps) {
        String name = attributeRole.getAttribute().getName();
        if (this.nameToAttributeRoleMap.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate attribute name: " + name);
        }
        String specialName = attributeRole.getSpecialName();
        if (specialName != null && this.specialNameToAttributeRoleMap.containsKey(specialName)) {
            throw new IllegalArgumentException("Duplicate attribute role: " + specialName);
        }
        this.nameToAttributeRoleMap.put(name, attributeRole);
        if (specialName != null) {
            this.specialNameToAttributeRoleMap.put(specialName, attributeRole);
        }
        if (!onlyMaps) {
            this.attributes.add(attributeRole);
        }
        attributeRole.addOwner(this);
        attributeRole.getAttribute().addOwner(this);
    }

    private boolean unregister(AttributeRole attributeRole, boolean onlyMap) {
        if (!this.nameToAttributeRoleMap.containsKey(attributeRole.getAttribute().getName())) {
            return false;
        }
        this.nameToAttributeRoleMap.remove(attributeRole.getAttribute().getName());
        if (attributeRole.getSpecialName() != null) {
            this.specialNameToAttributeRoleMap.remove(attributeRole.getSpecialName());
        }
        if (!onlyMap) {
            this.attributes.remove(attributeRole);
        }
        attributeRole.removeOwner(this);
        attributeRole.getAttribute().removeOwner(this);
        return true;
    }

    @Override
    public void rename(AttributeRole attributeRole, String newSpecialName) {
        if (attributeRole.getSpecialName() != null) {
            AttributeRole role = this.specialNameToAttributeRoleMap.get(attributeRole.getSpecialName());
            if (role == null) {
                throw new NoSuchElementException("Cannot rename attribute role. No such attribute role: " + attributeRole.getSpecialName());
            }
            if (role != attributeRole) {
                throw new RuntimeException("Broken attribute role map.");
            }
        }
        this.specialNameToAttributeRoleMap.remove(attributeRole.getSpecialName());
        if (newSpecialName != null) {
            this.specialNameToAttributeRoleMap.put(newSpecialName, attributeRole);
        }
    }

    @Override
    public void rename(Attribute attribute, String newName) {
        if (this.nameToAttributeRoleMap.containsKey(newName)) {
            throw new IllegalArgumentException("Cannot rename attribute. Duplicate name: " + newName);
        }
        AttributeRole role = this.nameToAttributeRoleMap.get(attribute.getName());
        if (role == null) {
            throw new NoSuchElementException("Cannot rename attribute. No such attribute: " + attribute.getName());
        }
        if (role.getAttribute() != attribute) {
            throw new RuntimeException("Broken attribute map.");
        }
        this.nameToAttributeRoleMap.remove(role.getAttribute().getName());
        this.nameToAttributeRoleMap.put(newName, role);
    }

    @Override
    public void add(AttributeRole attributeRole) {
        this.register(attributeRole, false);
    }

    @Override
    public boolean remove(AttributeRole attributeRole) {
        return this.unregister(attributeRole, false);
    }

    @Override
    public AttributeRole findRoleByName(String name, boolean caseSensitive) {
        if (caseSensitive) {
            return this.nameToAttributeRoleMap.get(name);
        }
        String lowerSearchTerm = name.toLowerCase();
        for (Map.Entry<String, AttributeRole> entry : this.nameToAttributeRoleMap.entrySet()) {
            if (!lowerSearchTerm.equals(entry.getKey().toLowerCase())) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public AttributeRole findRoleBySpecialName(String specialName, boolean caseSensitive) {
        if (caseSensitive) {
            return this.specialNameToAttributeRoleMap.get(specialName);
        }
        String lowerSearchTerm = specialName.toLowerCase();
        for (Map.Entry<String, AttributeRole> entry : this.specialNameToAttributeRoleMap.entrySet()) {
            if (!lowerSearchTerm.equals(entry.getKey().toLowerCase())) continue;
            return entry.getValue();
        }
        return null;
    }
}

