/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Statistics;
import com.rapidminer.tools.LogService;

public class NumericalStatistics
implements Statistics {
    private static final long serialVersionUID = -6283236022093847887L;
    private double sum = 0.0;
    private double squaredSum = 0.0;
    private int valueCounter = 0;

    public NumericalStatistics() {
    }

    private NumericalStatistics(NumericalStatistics other) {
        this.sum = other.sum;
        this.squaredSum = other.squaredSum;
        this.valueCounter = other.valueCounter;
    }

    @Override
    public Object clone() {
        return new NumericalStatistics(this);
    }

    @Override
    public void startCounting(Attribute attribute) {
        this.sum = 0.0;
        this.squaredSum = 0.0;
        this.valueCounter = 0;
    }

    @Override
    public void count(double value, double weight) {
        if (!Double.isNaN(value)) {
            this.sum += value;
            this.squaredSum += value * value;
            ++this.valueCounter;
        }
    }

    @Override
    public boolean handleStatistics(String name) {
        return "average".equals(name) || "variance".equals(name) || "sum".equals(name);
    }

    @Override
    public double getStatistics(Attribute attribute, String name, String parameter) {
        if ("average".equals(name)) {
            return this.sum / (double)this.valueCounter;
        }
        if ("variance".equals(name)) {
            if (this.valueCounter <= 1) {
                return 0.0;
            }
            double variance = (this.squaredSum - this.sum * this.sum / (double)this.valueCounter) / (double)(this.valueCounter - 1);
            if (variance < 0.0) {
                return 0.0;
            }
            return variance;
        }
        if ("sum".equals(name)) {
            return this.sum;
        }
        LogService.getGlobal().log("Cannot calculate statistics, unknown type: " + name, 5);
        return Double.NaN;
    }
}

