/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import java.util.ArrayList;

public class ExampleSetFactory {
    public static ExampleSet createExampleSet(double[][] data) {
        return ExampleSetFactory.createExampleSet(data, null);
    }

    public static ExampleSet createExampleSet(double[][] data, int classColumn) {
        if (data.length == 0) {
            throw new RuntimeException("ExampleSetFactory.createExampleSet(double[][], int): data matrix is not allowed to be empty.");
        }
        double[][] dataWithoutLabel = new double[data.length][data[0].length - 1];
        double[] labels = new double[data.length];
        for (int e = 0; e < data.length; ++e) {
            int counter = 0;
            for (int a = 0; a < data[e].length; ++a) {
                if (a == classColumn) {
                    labels[e] = data[e][a];
                    continue;
                }
                dataWithoutLabel[e][counter++] = data[e][a];
            }
        }
        return ExampleSetFactory.createExampleSet(dataWithoutLabel, labels);
    }

    public static ExampleSet createExampleSet(double[][] data, double[] labels) {
        if (data.length == 0) {
            throw new RuntimeException("ExampleSetFactory.createExampleSet(double[][], double[]): data matrix is not allowed to be empty.");
        }
        int numberOfAttributes = data[0].length;
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>(numberOfAttributes + (labels != null ? 1 : 0));
        for (int a = 0; a < numberOfAttributes; ++a) {
            attributeList.add(AttributeFactory.createAttribute("att" + (a + 1), 2));
        }
        Attribute labelAttribute = null;
        if (labels != null) {
            labelAttribute = AttributeFactory.createAttribute("label", 2);
            attributeList.add(labelAttribute);
        }
        MemoryExampleTable table = new MemoryExampleTable(attributeList);
        for (int e = 0; e < data.length; ++e) {
            double[] dataRow = data[e];
            if (labelAttribute != null) {
                dataRow = new double[numberOfAttributes + 1];
                System.arraycopy(data[e], 0, dataRow, 0, data[e].length);
                dataRow[dataRow.length - 1] = labels[e];
            }
            table.addDataRow(new DoubleArrayDataRow(dataRow));
        }
        return table.createExampleSet(labelAttribute);
    }

    public static ExampleSet createExampleSet(Object[][] data) {
        return ExampleSetFactory.createExampleSet(data, null);
    }

    public static ExampleSet createExampleSet(Object[][] data, int classColumn) {
        if (data.length == 0) {
            throw new RuntimeException("ExampleSetFactory.createExampleSet(Object[][], int): data matrix is not allowed to be empty.");
        }
        Object[][] dataWithoutLabel = new Object[data.length][data[0].length - 1];
        Object[] labels = new Object[data.length];
        for (int e = 0; e < data.length; ++e) {
            int counter = 0;
            for (int a = 0; a < data[e].length; ++a) {
                if (a == classColumn) {
                    labels[e] = data[e][a];
                    continue;
                }
                dataWithoutLabel[e][counter++] = data[e][a];
            }
        }
        return ExampleSetFactory.createExampleSet(dataWithoutLabel, labels);
    }

    public static ExampleSet createExampleSet(Object[][] data, Object[] labels) {
        Object current;
        if (data.length == 0) {
            throw new RuntimeException("ExampleSetFactory.createExampleSet(Object[][], Object[]): data matrix is not allowed to be empty.");
        }
        int numberOfAttributes = data[0].length;
        int totalNumber = numberOfAttributes + (labels != null ? 1 : 0);
        boolean[] nominal = new boolean[totalNumber];
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>(totalNumber);
        for (int a = 0; a < numberOfAttributes; ++a) {
            current = data[0][a];
            if (current instanceof Number) {
                attributeList.add(AttributeFactory.createAttribute("att" + (a + 1), 2));
                nominal[a] = false;
                continue;
            }
            if (current instanceof String) {
                attributeList.add(AttributeFactory.createAttribute("att" + (a + 1), 1));
                nominal[a] = true;
                continue;
            }
            throw new RuntimeException("ExampleSetFactory.createExampleSet(Object[][], Object[]): only objects of type String or Number (Double, Integer) are allowed for the object data matrix.");
        }
        Attribute labelAttribute = null;
        if (labels != null) {
            current = labels[0];
            if (current instanceof Number) {
                labelAttribute = AttributeFactory.createAttribute("label", 2);
                nominal[nominal.length - 1] = false;
            } else if (current instanceof String) {
                labelAttribute = AttributeFactory.createAttribute("label", 1);
                nominal[nominal.length - 1] = true;
            } else {
                throw new RuntimeException("ExampleSetFactory.createExampleSet(Object[][], Object[]): only objects of type String or Number (Double, Integer) are allowed for the object data matrix.");
            }
            attributeList.add(labelAttribute);
        }
        MemoryExampleTable table = new MemoryExampleTable(attributeList);
        for (int e = 0; e < data.length; ++e) {
            double[] dataRow = new double[totalNumber];
            for (int a = 0; a < numberOfAttributes; ++a) {
                Object current2 = data[e][a];
                if (current2 instanceof Number) {
                    if (nominal[a]) {
                        throw new RuntimeException("ExampleSetFactory.createExampleSet(Object[][], Object[]): type of objects did change in column. Only the same type of objects is allowed for complete columns.");
                    }
                    dataRow[a] = ((Number)current2).doubleValue();
                    continue;
                }
                if (current2 instanceof String) {
                    if (!nominal[a]) {
                        throw new RuntimeException("ExampleSetFactory.createExampleSet(Object[][], Object[]): type of objects did change in column. Only the same type of objects is allowed for complete columns.");
                    }
                    dataRow[a] = ((Attribute)attributeList.get(a)).getMapping().mapString((String)current2);
                    continue;
                }
                throw new RuntimeException("ExampleSetFactory.createExampleSet(Object[][], Object[]): only objects of type String or Number (Double, Integer) are allowed for the object data matrix.");
            }
            if (labelAttribute != null) {
                Object current3 = labels[e];
                if (current3 instanceof Number) {
                    if (nominal[nominal.length - 1]) {
                        throw new RuntimeException("ExampleSetFactory.createExampleSet(Object[][], Object[]): type of objects did change in column. Only the same type of objects is allowed for complete columns.");
                    }
                    dataRow[dataRow.length - 1] = ((Number)current3).doubleValue();
                } else if (current3 instanceof String) {
                    if (!nominal[nominal.length - 1]) {
                        throw new RuntimeException("ExampleSetFactory.createExampleSet(Object[][], Object[]): type of objects did change in column. Only the same type of objects is allowed for complete columns.");
                    }
                    dataRow[dataRow.length - 1] = ((Attribute)attributeList.get(attributeList.size() - 1)).getMapping().mapString((String)current3);
                } else {
                    throw new RuntimeException("ExampleSetFactory.createExampleSet(Object[][], Object[]): only objects of type String or Number (Double, Integer) are allowed for the object data matrix.");
                }
            }
            table.addDataRow(new DoubleArrayDataRow(dataRow));
        }
        return table.createExampleSet(labelAttribute);
    }
}

