/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.FormatterException;
import com.rapidminer.tools.Tools;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ExampleFormatter {
    private FormatCommand[] formatCommands;

    public ExampleFormatter(FormatCommand[] formatCommands) {
        this.formatCommands = formatCommands;
    }

    public static ExampleFormatter compile(String formatString, ExampleSet exampleSet, int fractionDigits, boolean quoteWhitespace) throws FormatterException {
        LinkedList<FormatCommand> commandList = new LinkedList<FormatCommand>();
        ExampleFormatter.compile(formatString, exampleSet, commandList, fractionDigits, quoteWhitespace);
        FormatCommand[] commands = new FormatCommand[commandList.size()];
        commandList.toArray(commands);
        return new ExampleFormatter(commands);
    }

    private static void compile(String formatString, ExampleSet exampleSet, List<FormatCommand> commandList, int fractionDigits, boolean quoteWhitespace) throws FormatterException {
        int start = 0;
        block3: while (true) {
            int tagStart;
            if ((tagStart = formatString.indexOf("$", start)) == -1) break;
            if (tagStart == formatString.length() - 1) {
                throw new FormatterException("Format string ends in '$'.");
            }
            commandList.add(new TextCommand(formatString.substring(start, tagStart)));
            char command = formatString.charAt(tagStart + 1);
            if (command == '$' || command == '[' || command == ']') {
                commandList.add(new TextCommand("" + command));
                start = tagStart + 2;
                continue;
            }
            if (command == 'n') {
                commandList.add(new TextCommand(Tools.getLineSeparator()));
                start = tagStart + 2;
                continue;
            }
            if (command == 't') {
                commandList.add(new TextCommand("\t"));
                start = tagStart + 2;
                continue;
            }
            start = tagStart + 2;
            LinkedList<String> argumentList = new LinkedList<String>();
            while (start < formatString.length() && formatString.charAt(start) == '[') {
                int end = formatString.indexOf(93, start);
                if (end == -1) {
                    throw new FormatterException("Unclosed '['!");
                }
                argumentList.add(formatString.substring(start + 1, end));
                start = end + 1;
            }
            String[] arguments = new String[argumentList.size()];
            argumentList.toArray(arguments);
            switch (command) {
                case 'k': 
                case 'v': {
                    commandList.add(new ValueCommand(command, arguments, exampleSet, fractionDigits, quoteWhitespace));
                    continue block3;
                }
            }
            commandList.add(new SimpleCommand(exampleSet, command, arguments, fractionDigits, quoteWhitespace));
        }
        commandList.add(new TextCommand(formatString.substring(start)));
    }

    public String format(Example example) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < this.formatCommands.length; ++i) {
            str.append(this.formatCommands[i].format(example));
        }
        return str.toString();
    }

    public static class TextCommand
    implements FormatCommand {
        private String text;

        private TextCommand(String text) {
            this.text = text;
        }

        @Override
        public String format(Example example) {
            return this.text;
        }
    }

    public static class ValueCommand
    implements FormatCommand {
        private Attribute attribute;
        private int fractionDigits = -1;
        private boolean quoteWhitespace = false;

        public ValueCommand(char command, String[] arguments, ExampleSet exampleSet, int fractionDigits, boolean quoteWhitespace) throws FormatterException {
            this.fractionDigits = fractionDigits;
            this.quoteWhitespace = quoteWhitespace;
            if (arguments.length < 1) {
                throw new FormatterException("Command 'v' needs argument!");
            }
            switch (command) {
                case 'v': {
                    this.attribute = exampleSet.getAttributes().get(arguments[0]);
                    if (this.attribute != null) break;
                    throw new FormatterException("Unknown attribute: '" + arguments[0] + "'!");
                }
                case 'k': {
                    int column = -1;
                    try {
                        column = Integer.parseInt(arguments[0]);
                    }
                    catch (NumberFormatException e) {
                        throw new FormatterException("Argument for 'k' must be an integer!");
                    }
                    if (column < 0 || column >= exampleSet.getAttributes().size()) {
                        throw new FormatterException("Illegal column: '" + arguments[0] + "'!");
                    }
                    int counter = 0;
                    for (Attribute attribute : exampleSet.getAttributes()) {
                        if (counter >= column) {
                            this.attribute = attribute;
                            break;
                        }
                        ++counter;
                    }
                    if (this.attribute != null) break;
                    throw new FormatterException("Attribute #" + column + " not found.");
                }
                default: {
                    throw new FormatterException("Illegal command for ValueCommand: '" + command + "'");
                }
            }
        }

        @Override
        public String format(Example example) {
            return example.getValueAsString(this.attribute, this.fractionDigits, this.quoteWhitespace);
        }
    }

    public static class SimpleCommand
    implements FormatCommand {
        private char command;
        private String[] arguments;
        private int fractionDigits = -1;
        private boolean quoteNominal;

        private SimpleCommand(ExampleSet exampleSet, char command, String[] arguments, int fractionDigits, boolean quoteNominal) throws FormatterException {
            this.command = command;
            this.fractionDigits = fractionDigits;
            this.quoteNominal = quoteNominal;
            if (command != 'a' && command != 's' && command != 'l' && command != 'p' && command != 'd' && command != 'i' && command != 'w' && command != 'c' && command != 'b') {
                throw new FormatterException("Unknown command: '" + command + "'");
            }
            switch (command) {
                case 'a': {
                    if (arguments.length != 0) break;
                    arguments = new String[]{" "};
                    break;
                }
                case 's': {
                    if (arguments.length == 0) {
                        arguments = new String[]{" ", ":"};
                    }
                    if (arguments.length == 1) {
                        arguments = new String[]{arguments[0], ":"};
                    }
                    if (arguments.length == 2) {
                        arguments = new String[]{arguments[0], arguments[1]};
                    }
                    if (arguments.length <= 2) break;
                    throw new FormatterException("For command 's' only up to two arguments (separator and sparse separator) are allowed.");
                }
                case 'l': {
                    if (exampleSet.getAttributes().getLabel() != null) break;
                    throw new FormatterException("Example set does not provide 'label' attribute, $l will not work.");
                }
                case 'p': {
                    if (exampleSet.getAttributes().getPredictedLabel() != null) break;
                    throw new FormatterException("Example set does not provide 'predicted label' attribute, $p will not work.");
                }
                case 'i': {
                    if (exampleSet.getAttributes().getId() != null) break;
                    throw new FormatterException("Example set does not provide 'id' attribute, $i will not work.");
                }
                case 'w': {
                    if (exampleSet.getAttributes().getWeight() != null) break;
                    throw new FormatterException("Example set does not provide 'weight' attribute, $w will not work.");
                }
                case 'c': {
                    if (exampleSet.getAttributes().getCluster() != null) break;
                    throw new FormatterException("Example set does not provide 'cluster' attribute, $c will not work.");
                }
                case 'b': {
                    if (exampleSet.getAttributes().getSpecial("batch") != null) break;
                    throw new FormatterException("Example set does not provide 'batch' attribute, $b will not work.");
                }
                case 'd': {
                    if (exampleSet.getAttributes().getPredictedLabel() != null) break;
                    throw new FormatterException("Example set does not provide 'confidence' attributes, $d will not work.");
                }
            }
            this.arguments = arguments;
        }

        @Override
        public String format(Example example) {
            switch (this.command) {
                case 'a': {
                    StringBuffer str = new StringBuffer();
                    boolean first = true;
                    for (Attribute attribute : example.getAttributes()) {
                        if (!first) {
                            str.append(this.arguments[0]);
                        }
                        str.append(example.getValueAsString(attribute, this.fractionDigits, this.quoteNominal));
                        first = false;
                    }
                    return str.toString();
                }
                case 's': {
                    return example.getAttributesAsSparseString(this.arguments[0], this.arguments[1], this.fractionDigits, this.quoteNominal);
                }
                case 'l': {
                    return example.getValueAsString(example.getAttributes().getLabel(), this.fractionDigits, this.quoteNominal);
                }
                case 'p': {
                    return example.getValueAsString(example.getAttributes().getPredictedLabel(), this.fractionDigits, this.quoteNominal);
                }
                case 'i': {
                    return example.getValueAsString(example.getAttributes().getId(), this.fractionDigits, this.quoteNominal);
                }
                case 'w': {
                    return example.getValueAsString(example.getAttributes().getWeight(), this.fractionDigits, this.quoteNominal);
                }
                case 'c': {
                    return example.getValueAsString(example.getAttributes().getCluster(), this.fractionDigits, this.quoteNominal);
                }
                case 'b': {
                    return example.getValueAsString(example.getAttributes().getSpecial("batch"), this.fractionDigits, this.quoteNominal);
                }
                case 'd': {
                    if (this.arguments.length == 0) {
                        Iterator<String> i = example.getAttributes().getPredictedLabel().getMapping().getValues().iterator();
                        StringBuffer result = new StringBuffer();
                        int index = 0;
                        while (i.hasNext()) {
                            String value = i.next();
                            if (index != 0) {
                                result.append(" ");
                            }
                            result.append("conf(" + value + ")=" + Tools.formatNumber(example.getConfidence(value), this.fractionDigits));
                            ++index;
                        }
                        return result.toString();
                    }
                    return Tools.formatNumber(example.getConfidence(this.arguments[0]), this.fractionDigits);
                }
            }
            return this.command + "";
        }
    }

    public static interface FormatCommand {
        public String format(Example var1);
    }
}

