/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example;

import com.rapidminer.RapidMiner;
import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.SimpleDataTable;
import com.rapidminer.datatable.SimpleDataTableRow;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeight;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.AverageVector;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AttributeWeights
extends AverageVector {
    private static final long serialVersionUID = 7000978931118131854L;
    public static final int NO_SORTING = 0;
    public static final int DECREASING = -1;
    public static final int INCREASING = 1;
    public static final int ORIGINAL_WEIGHTS = 0;
    public static final int ABSOLUTE_WEIGHTS = 1;
    private int sortType = 0;
    private int weightType = 0;
    private Map<String, AttributeWeight> weightMap = new LinkedHashMap<String, AttributeWeight>();

    public AttributeWeights() {
    }

    public AttributeWeights(ExampleSet exampleSet) {
        for (Attribute attribute : exampleSet.getAttributes()) {
            this.setWeight(attribute.getName(), 1.0);
        }
    }

    private AttributeWeights(AttributeWeights weights) {
        for (String name : weights.getAttributeNames()) {
            this.setWeight(name, weights.getWeight(name));
        }
    }

    @Override
    public String getName() {
        return "AttributeWeights";
    }

    public void setWeight(String name, double weight) {
        AttributeWeight oldWeight = this.weightMap.get(name);
        if (Double.isNaN(weight)) {
            this.weightMap.remove(name);
            super.removeAveragable(oldWeight);
        } else if (oldWeight == null) {
            AttributeWeight attWeight = new AttributeWeight(this, name, weight);
            super.addAveragable(attWeight);
            this.weightMap.put(name, attWeight);
        } else {
            oldWeight.setWeight(weight);
        }
    }

    public double getWeight(String name) {
        AttributeWeight weight = this.weightMap.get(name);
        if (weight == null) {
            return Double.NaN;
        }
        return weight.getWeight();
    }

    public int getWeightType() {
        return this.weightType;
    }

    public void setWeightType(int weightType) {
        this.weightType = weightType;
    }

    public int getSortingType() {
        return this.sortType;
    }

    public void setSortingType(int sortingType) {
        this.sortType = sortingType;
    }

    @Override
    public int size() {
        return this.weightMap.size();
    }

    public void removeAttributeWeight(String attributeName) {
        this.weightMap.remove(attributeName);
    }

    public Set<String> getAttributeNames() {
        return this.weightMap.keySet();
    }

    public int compareTo(Object o) {
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof AttributeWeights)) {
            return false;
        }
        AttributeWeights other = (AttributeWeights)o;
        return ((Object)this.weightMap).equals(other.weightMap);
    }

    @Override
    public int hashCode() {
        return ((Object)this.weightMap).hashCode();
    }

    public void sortByWeight(String[] attributeNames, int direction, int comparatorType) {
        Arrays.sort(attributeNames, new WeightComparator(direction, comparatorType));
    }

    public void sort(int direction, int comparatorType) {
        LinkedHashMap<String, AttributeWeight> newWeightMap = new LinkedHashMap<String, AttributeWeight>();
        ArrayList<String> attributes = new ArrayList<String>(this.weightMap.keySet());
        Collections.sort(attributes, new WeightComparator(direction, comparatorType));
        for (String attributeName : attributes) {
            newWeightMap.put(attributeName, this.weightMap.get(attributeName));
        }
        this.weightMap = newWeightMap;
    }

    public void save(File file) throws IOException {
        this.writeAttributeWeights(file, Tools.getDefaultEncoding());
    }

    public void writeAttributeWeights(File file, Charset encoding) throws IOException {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(file));
            out.println("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>");
            out.println("<attributeweights version=\"" + RapidMiner.getShortVersion() + "\">");
            for (String key : this.weightMap.keySet()) {
                double weight = this.weightMap.get(key).getWeight();
                out.println("    <weight name=\"" + key + "\" value=\"" + weight + "\"/>");
            }
            out.println("</attributeweights>");
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static AttributeWeights load(File file) throws IOException {
        AttributeWeights result = new AttributeWeights();
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
        }
        catch (SAXException e1) {
            throw new IOException(e1.getMessage());
        }
        catch (ParserConfigurationException e1) {
            throw new IOException(e1.getMessage());
        }
        Element attributeWeightsElement = document.getDocumentElement();
        if (!attributeWeightsElement.getTagName().equals("attributeweights")) {
            throw new IOException("Outer tag of attribute weights file must be <attributeweights>");
        }
        NodeList weights = attributeWeightsElement.getChildNodes();
        for (int i = 0; i < weights.getLength(); ++i) {
            Node node = weights.item(i);
            if (!(node instanceof Element)) continue;
            Element weightTag = (Element)node;
            String tagName = weightTag.getTagName();
            if (!tagName.equals("weight")) {
                throw new IOException("Only tags <weight> are allowed, was " + tagName);
            }
            String name = weightTag.getAttribute("name");
            String value = weightTag.getAttribute("value");
            double weight = 1.0;
            try {
                weight = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                throw new IOException("Only numerical weights are allowed for the 'value' attribute.");
            }
            result.setWeight(name, weight);
        }
        return result;
    }

    public String getExtension() {
        return "wgt";
    }

    public String getFileDescription() {
        return "attribute weights file";
    }

    @Override
    public String toString() {
        return "AttributeWeights (containing weights for " + this.weightMap.size() + " attributes)";
    }

    @Override
    public Object clone() {
        return new AttributeWeights(this);
    }

    public void normalize() {
        double weightMin = Double.POSITIVE_INFINITY;
        double weightMax = Double.NEGATIVE_INFINITY;
        for (String name : this.getAttributeNames()) {
            double weight = Math.abs(this.getWeight(name));
            weightMin = Math.min(weightMin, weight);
            weightMax = Math.max(weightMax, weight);
        }
        Iterator<AttributeWeight> w = this.weightMap.values().iterator();
        double diff = weightMax - weightMin;
        while (w.hasNext()) {
            AttributeWeight attributeWeight = w.next();
            double newWeight = 1.0;
            if (diff != 0.0) {
                newWeight = (Math.abs(attributeWeight.getWeight()) - weightMin) / diff;
            }
            attributeWeight.setWeight(newWeight);
        }
    }

    public DataTable createDataTable() {
        SimpleDataTable dataTable = new SimpleDataTable("Attribute Weights", new String[]{"attribute", "weight"});
        for (Map.Entry<String, AttributeWeight> entry : this.weightMap.entrySet()) {
            String attName = entry.getKey();
            AttributeWeight attWeight = entry.getValue();
            double index = dataTable.mapString(0, attName);
            double weightValue = attWeight.getWeight();
            double[] data = new double[]{index, weightValue};
            dataTable.add(new SimpleDataTableRow(data, attName));
        }
        return dataTable;
    }

    private class WeightComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 5013281668316451984L;
        private final int comparatorWeightType;
        private final int direction;

        public WeightComparator(int direction, int comparatorWeightType) {
            this.comparatorWeightType = comparatorWeightType;
            this.direction = direction;
        }

        @Override
        public int compare(String o1, String o2) {
            double w1 = ((AttributeWeight)AttributeWeights.this.weightMap.get(o1)).getWeight();
            double w2 = ((AttributeWeight)AttributeWeights.this.weightMap.get(o2)).getWeight();
            if (this.comparatorWeightType == 1) {
                w1 = Math.abs(w1);
                w2 = Math.abs(w2);
            }
            return Double.compare(w2, w1) * this.direction;
        }
    }
}

