/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.generator.FeatureGenerator;
import com.rapidminer.generator.GenerationException;
import com.rapidminer.tools.LoggingHandler;
import com.rapidminer.tools.math.function.ExpressionParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Stack;

@Deprecated
public class AttributeParser {
    @Deprecated
    public static void generateAll(LoggingHandler logging, ExampleSet exampleSet, InputStream in) throws IOException, GenerationException {
        ExpressionParser.generateAll(logging, exampleSet, in);
    }

    public Attribute generateAttribute(LoggingHandler logging, String constructionDescription, ExampleTable table) throws GenerationException {
        LinkedList<Construction> toConstruct = new LinkedList<Construction>();
        this.parseAttributes(constructionDescription, toConstruct);
        return this.generate(logging, toConstruct, table);
    }

    private static int getClosingBracketIndex(String string, int startIndex) throws GenerationException {
        int nextClosing;
        int openCount = 1;
        do {
            int nextOpen = string.indexOf("(", startIndex + 1);
            nextClosing = string.indexOf(")", startIndex + 1);
            if (nextClosing == -1) {
                throw new GenerationException("Malformed attribute description: mismatched parantheses");
            }
            if (nextOpen != -1 && nextOpen < nextClosing) {
                ++openCount;
                startIndex = nextOpen;
                continue;
            }
            --openCount;
            startIndex = nextClosing;
        } while (openCount != 0);
        return nextClosing;
    }

    private List<Construction> parseAttributes(String constructionString, Queue<Construction> toConstruct) throws GenerationException {
        int start = 0;
        LinkedList<Construction> constructedList = new LinkedList<Construction>();
        while (start < constructionString.length()) {
            String name;
            int end;
            int leftBr = constructionString.indexOf("(", start);
            int comma = constructionString.indexOf(",", start);
            if (comma == -1 && leftBr == -1) {
                end = constructionString.length();
                name = constructionString.substring(start, end).trim();
                if (name.startsWith("const")) {
                    throw new GenerationException("The function name 'const' must be used with empty arguments, for example 'const[5]()'!");
                }
                toConstruct.add(new Construction(name));
                constructedList.add(toConstruct.peek());
                start = constructionString.length();
                continue;
            }
            if (leftBr == -1 || comma < leftBr && comma != -1) {
                end = comma;
                name = constructionString.substring(start, end).trim();
                if (name.startsWith("const")) {
                    throw new GenerationException("The function name 'const' must be used with empty arguments, for example 'const[5]()'!");
                }
                toConstruct.add(new Construction(name));
                constructedList.add(toConstruct.peek());
                start = end + 1;
                continue;
            }
            int rightBr = AttributeParser.getClosingBracketIndex(constructionString, leftBr);
            String functionName = constructionString.substring(start, leftBr).trim();
            List<Construction> argumentList = this.parseAttributes(constructionString.substring(leftBr + 1, rightBr).trim(), toConstruct);
            Construction[] argumentDescriptions = new Construction[argumentList.size()];
            for (int i = 0; i < argumentDescriptions.length; ++i) {
                argumentDescriptions[i] = argumentList.get(i);
            }
            Construction generated = new Construction(functionName, argumentDescriptions);
            toConstruct.add(generated);
            constructedList.add(generated);
            start = constructionString.indexOf(",", rightBr) + 1;
            if (start > 0) continue;
            start = constructionString.length();
        }
        return constructedList;
    }

    private Attribute findInTable(String constructionDescription, ExampleTable table) {
        for (int i = 0; i < table.getNumberOfAttributes(); ++i) {
            Attribute a = table.getAttribute(i);
            if (a == null || !a.getConstruction().equals(constructionDescription)) continue;
            return a;
        }
        return null;
    }

    private Attribute generate(LoggingHandler logging, Queue<Construction> toConstruct, ExampleTable table) throws GenerationException {
        LinkedList<Attribute> allGeneratedAttributes = new LinkedList<Attribute>();
        Attribute currentAttribute = null;
        Stack<Attribute> resultStack = new Stack<Attribute>();
        while (toConstruct.size() > 0) {
            Construction construction = toConstruct.remove();
            if (construction.getNumberOfArguments() == 0) {
                FeatureGenerator generator = FeatureGenerator.createGeneratorForFunction(construction.getFunction());
                if (generator == null) {
                    Attribute attribute = this.findInTable(construction.getFunction(), table);
                    if (attribute == null) {
                        throw new GenerationException("No such attribute: " + construction.getFunction());
                    }
                    resultStack.push(attribute);
                    continue;
                }
                LinkedList<FeatureGenerator> generatorList = new LinkedList<FeatureGenerator>();
                generatorList.add(generator);
                List<Attribute> currentResultList = FeatureGenerator.generateAll(table, generatorList);
                currentAttribute = currentResultList.get(0);
                resultStack.push(currentAttribute);
                if (toConstruct.size() <= 0) continue;
                allGeneratedAttributes.add(currentAttribute);
                continue;
            }
            int numberOfArguments = construction.getNumberOfArguments();
            Attribute[] inputAttributes = new Attribute[numberOfArguments];
            for (int i = 0; i < numberOfArguments; ++i) {
                inputAttributes[inputAttributes.length - 1 - i] = (Attribute)resultStack.pop();
            }
            FeatureGenerator generator = FeatureGenerator.createGeneratorForFunction(construction.getFunction());
            generator.setArguments(inputAttributes);
            LinkedList<FeatureGenerator> generatorList = new LinkedList<FeatureGenerator>();
            generatorList.add(generator);
            List<Attribute> currentResultList = FeatureGenerator.generateAll(table, generatorList);
            currentAttribute = currentResultList.get(0);
            resultStack.push(currentAttribute);
            if (toConstruct.size() <= 0) continue;
            allGeneratedAttributes.add(currentAttribute);
        }
        for (Attribute attribute : allGeneratedAttributes) {
            table.removeAttribute(attribute);
        }
        return currentAttribute;
    }

    private static class Construction {
        String function;
        Construction[] arguments;

        public Construction(String function) {
            this.function = function;
        }

        public Construction(String function, Construction[] arguments) {
            this.function = function;
            this.arguments = arguments;
        }

        public int getNumberOfArguments() {
            if (this.arguments == null) {
                return 0;
            }
            return this.arguments.length;
        }

        public String getFunction() {
            return this.function;
        }

        public String toString() {
            if (this.arguments == null) {
                return this.function;
            }
            StringBuffer result = new StringBuffer(this.function + "(");
            boolean first = true;
            for (Construction construction : this.arguments) {
                if (!first) {
                    result.append(", ");
                }
                result.append(construction.toString());
                first = false;
            }
            result.append(")");
            return result.toString();
        }
    }
}

