/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import java.util.Iterator;

public class AttributeIterator
implements Iterator<Attribute> {
    private Iterator<AttributeRole> parent;
    private int type = 0;
    private Attribute current = null;
    private boolean hasNextInvoked = false;
    private AttributeRole currentRole = null;

    public AttributeIterator(Iterator<AttributeRole> parent, int type) {
        this.parent = parent;
        this.type = type;
    }

    @Override
    public boolean hasNext() {
        this.hasNextInvoked = true;
        if (!this.parent.hasNext() && this.currentRole == null) {
            this.current = null;
            return false;
        }
        AttributeRole role = this.currentRole == null ? this.parent.next() : this.currentRole;
        switch (this.type) {
            case 0: {
                if (!role.isSpecial()) {
                    this.current = role.getAttribute();
                    this.currentRole = role;
                    return true;
                }
                return this.hasNext();
            }
            case 1: {
                if (role.isSpecial()) {
                    this.current = role.getAttribute();
                    this.currentRole = role;
                    return true;
                }
                return this.hasNext();
            }
            case 2: {
                this.current = role.getAttribute();
                this.currentRole = role;
                return true;
            }
        }
        this.current = null;
        return false;
    }

    @Override
    public Attribute next() {
        if (!this.hasNextInvoked) {
            this.hasNext();
        }
        this.hasNextInvoked = false;
        this.currentRole = null;
        return this.current;
    }

    @Override
    public void remove() {
        this.parent.remove();
        this.currentRole = null;
        this.hasNextInvoked = false;
    }
}

