/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeIterator;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.AttributeRoleIterator;
import com.rapidminer.example.Attributes;
import com.rapidminer.tools.LogService;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public abstract class AbstractAttributes
implements Attributes {
    private static final long serialVersionUID = -3419958538074776957L;

    @Override
    public abstract Object clone();

    @Override
    public Iterator<Attribute> iterator() {
        return new AttributeIterator(this.allAttributeRoles(), 0);
    }

    @Override
    public Iterator<Attribute> allAttributes() {
        return new AttributeIterator(this.allAttributeRoles(), 2);
    }

    @Override
    public Iterator<AttributeRole> specialAttributes() {
        return new AttributeRoleIterator(this.allAttributeRoles(), 1);
    }

    @Override
    public Iterator<AttributeRole> regularAttributes() {
        return new AttributeRoleIterator(this.allAttributeRoles(), 0);
    }

    @Override
    public boolean contains(Attribute attribute) {
        return this.findAttributeRole(attribute.getName()) != null;
    }

    @Override
    public int allSize() {
        return this.calculateSize(this.allAttributes());
    }

    @Override
    public int size() {
        return this.calculateSize(this.iterator());
    }

    @Override
    public int specialSize() {
        return this.calculateSize(this.specialAttributes());
    }

    private int calculateSize(Iterator i) {
        int counter = 0;
        while (i.hasNext()) {
            i.next();
            ++counter;
        }
        return counter;
    }

    @Override
    public void addRegular(Attribute attribute) {
        this.add(new AttributeRole(attribute));
    }

    @Override
    public boolean remove(Attribute attribute) {
        AttributeRole role = this.getRole(attribute);
        if (role != null) {
            return this.remove(role);
        }
        return false;
    }

    @Override
    public void clearRegular() {
        LinkedList<AttributeRole> toRemove = new LinkedList<AttributeRole>();
        Iterator<AttributeRole> i = this.allAttributeRoles();
        while (i.hasNext()) {
            AttributeRole role = i.next();
            if (role.isSpecial()) continue;
            toRemove.add(role);
        }
        for (AttributeRole role : toRemove) {
            this.remove(role);
        }
    }

    @Override
    public void clearSpecial() {
        LinkedList<AttributeRole> toRemove = new LinkedList<AttributeRole>();
        Iterator<AttributeRole> i = this.allAttributeRoles();
        while (i.hasNext()) {
            AttributeRole role = i.next();
            if (!role.isSpecial()) continue;
            toRemove.add(role);
        }
        for (AttributeRole role : toRemove) {
            this.remove(role);
        }
    }

    @Override
    public Attribute replace(Attribute first, Attribute second) {
        AttributeRole role = this.getRole(first);
        if (role == null) {
            throw new NoSuchElementException("Attribute " + first + " cannot be replaced by attribute " + second + ": " + first + " is not part of the example set!");
        }
        role.setAttribute(second);
        return second;
    }

    @Override
    public Attribute get(String name) {
        return this.get(name, true);
    }

    @Override
    public Attribute get(String name, boolean caseSensitive) {
        AttributeRole result = this.findRoleByName(name, caseSensitive);
        if (result == null) {
            result = this.findRoleBySpecialName(name, caseSensitive);
        }
        if (result != null) {
            return result.getAttribute();
        }
        return null;
    }

    @Override
    public AttributeRole findRoleByName(String name) {
        return this.findRoleByName(name, true);
    }

    @Override
    public AttributeRole findRoleBySpecialName(String specialName) {
        return this.findRoleBySpecialName(specialName, true);
    }

    @Override
    public Attribute getRegular(String name) {
        AttributeRole role = this.findRoleByName(name);
        if (role != null) {
            if (!role.isSpecial()) {
                return role.getAttribute();
            }
            LogService.getGlobal().logWarning("No regular attribute with name '" + name + "' found, however, there is a special attribute with the same name.");
            return null;
        }
        return null;
    }

    @Override
    public Attribute getSpecial(String name) {
        AttributeRole role = this.findRoleBySpecialName(name);
        if (role == null) {
            return null;
        }
        return role.getAttribute();
    }

    @Override
    public AttributeRole getRole(Attribute attribute) {
        return this.getRole(attribute.getName());
    }

    @Override
    public AttributeRole getRole(String name) {
        return this.findAttributeRole(name);
    }

    @Override
    public Attribute getLabel() {
        return this.getSpecial("label");
    }

    @Override
    public void setLabel(Attribute label) {
        this.setSpecialAttribute(label, "label");
    }

    @Override
    public Attribute getPredictedLabel() {
        return this.getSpecial("prediction");
    }

    @Override
    public Attribute getConfidence(String classLabel) {
        return this.getSpecial("confidence_" + classLabel);
    }

    @Override
    public void setPredictedLabel(Attribute predictedLabel) {
        this.setSpecialAttribute(predictedLabel, "prediction");
    }

    @Override
    public Attribute getId() {
        return this.getSpecial("id");
    }

    @Override
    public void setId(Attribute id) {
        this.setSpecialAttribute(id, "id");
    }

    @Override
    public Attribute getWeight() {
        return this.getSpecial("weight");
    }

    @Override
    public void setWeight(Attribute weight) {
        this.setSpecialAttribute(weight, "weight");
    }

    @Override
    public Attribute getCluster() {
        return this.getSpecial("cluster");
    }

    @Override
    public void setCluster(Attribute cluster) {
        this.setSpecialAttribute(cluster, "cluster");
    }

    @Override
    public Attribute getOutlier() {
        return this.getSpecial("outlier");
    }

    @Override
    public void setOutlier(Attribute outlier) {
        this.setSpecialAttribute(outlier, "outlier");
    }

    @Override
    public Attribute getCost() {
        return this.getSpecial("cost");
    }

    @Override
    public void setCost(Attribute cost) {
        this.setSpecialAttribute(cost, "cost");
    }

    @Override
    public void setSpecialAttribute(Attribute attribute, String specialName) {
        AttributeRole oldRole = this.findRoleBySpecialName(specialName);
        if (oldRole != null) {
            this.remove(oldRole);
        }
        if (attribute != null) {
            this.remove(attribute);
            AttributeRole role = new AttributeRole(attribute);
            role.setSpecial(specialName);
            this.add(role);
        }
    }

    @Override
    public Attribute[] createRegularAttributeArray() {
        int index = 0;
        Attribute[] result = new Attribute[this.size()];
        for (Attribute attribute : this) {
            result[index++] = attribute;
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getSimpleName() + ": ");
        Iterator<AttributeRole> r = this.allAttributeRoles();
        boolean first = true;
        while (r.hasNext()) {
            if (!first) {
                result.append(", ");
            }
            result.append(r.next());
            first = false;
        }
        return result.toString();
    }

    private AttributeRole findAttributeRole(String name) {
        AttributeRole role = this.findRoleByName(name);
        if (role != null) {
            return role;
        }
        return this.findRoleBySpecialName(name);
    }
}

