/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.doc;

import com.rapidminer.doc.LatexOperatorDocGenerator;
import com.rapidminer.doc.OperatorDocGenerator;
import com.rapidminer.doc.ProgramHTMLOperatorDocGenerator;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.tools.GroupTree;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.Tools;
import com.sun.javadoc.RootDoc;
import com.sun.tools.javadoc.Main;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;

public class DocumentationGenerator {
    private OperatorDocGenerator generator;
    private static RootDoc rootDoc = null;

    public DocumentationGenerator(OperatorDocGenerator generator) {
        this.generator = generator;
    }

    private void getRootDoc() {
        try {
            this.getRootDoc(new File(ParameterService.getRapidMinerHome(), "src" + File.separator), "com.rapidminer.operator");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getRootDoc(File srcDir, String subpackages) {
        LogService.getGlobal().log("Starting javadoc!", 2);
        String[] javadocargs = new String[]{"-sourcepath", srcDir.getAbsolutePath(), "-doclet", this.getClass().getName(), "-breakiterator", "-subpackages", subpackages};
        Main.execute((String[])javadocargs);
        if (rootDoc == null) {
            LogService.getGlobal().log("RootDoc not set!", 6);
        }
    }

    public static boolean start(RootDoc rootDoc) {
        LogService.getGlobal().log("RootDoc generated!", 2);
        DocumentationGenerator.rootDoc = rootDoc;
        return true;
    }

    public void generateAll(PrintWriter out) {
        this.generateAll(out, false);
    }

    public void generateAll(PrintWriter out, boolean generateSubgroups) {
        GroupTree root = OperatorService.getGroups();
        if (root.getOperatorDescriptions().size() > 0) {
            this.generator.beginGroup(null, out);
            this.generateOperators(out, root.getOperatorDescriptions());
            this.generator.endGroup(null, out);
        }
        Collection<GroupTree> groups = root.getSubGroups();
        for (GroupTree group : groups) {
            this.generateGroup(out, group, generateSubgroups);
        }
        out.println();
        out.flush();
    }

    public void generateGroup(PrintWriter out, GroupTree group, boolean generateSubgroups) {
        this.generator.beginGroup(group.getName(), out);
        if (generateSubgroups) {
            this.generateOperators(out, group.getOperatorDescriptions());
            Collection<GroupTree> groups = group.getSubGroups();
            for (GroupTree subgroup : groups) {
                this.generateGroup(out, subgroup, generateSubgroups);
            }
        } else {
            this.generateOperators(out, group.getAllOperatorDescriptions());
        }
        this.generator.endGroup(group.getName(), out);
    }

    public void generateOperators(PrintWriter out, Collection<OperatorDescription> operators) {
        for (OperatorDescription description : operators) {
            try {
                Operator operator = description.createOperatorInstance();
                this.generator.generateDoc(operator, rootDoc, out);
            }
            catch (Exception e) {
                e.printStackTrace(out);
                System.err.println("Error in " + description.getName() + ": " + e.getMessage());
            }
        }
        out.println();
    }

    public static void main(String[] argv) throws IOException {
        if (argv.length == 1) {
            OperatorDocGenerator opDocGen = null;
            opDocGen = argv[0].equals("LATEX") ? new LatexOperatorDocGenerator() : new ProgramHTMLOperatorDocGenerator();
            ParameterService.init();
            File file = new File(ParameterService.getRapidMinerHome(), "tutorial" + File.separator + "OperatorsGenerated.tex");
            LogService.getGlobal().log("Generating class documentation to '" + file + "'.", 2);
            DocumentationGenerator docGen = new DocumentationGenerator(opDocGen);
            docGen.getRootDoc();
            docGen.generateAll(new PrintWriter(new FileWriter(file)));
        } else if (argv.length == 2) {
            OperatorDocGenerator opDocGen = null;
            opDocGen = argv[0].equals("LATEX") ? new LatexOperatorDocGenerator() : new ProgramHTMLOperatorDocGenerator();
            ParameterService.init();
            File file = new File(argv[1]);
            LogService.getGlobal().log("Generating class documentation to '" + file + "'.", 2);
            DocumentationGenerator docGen = new DocumentationGenerator(opDocGen);
            docGen.getRootDoc();
            docGen.generateAll(new PrintWriter(new FileWriter(file)));
        } else if (argv.length >= 5) {
            OperatorDocGenerator opDocGen = null;
            opDocGen = argv[0].equals("LATEX") ? new LatexOperatorDocGenerator() : new ProgramHTMLOperatorDocGenerator();
            try {
                OperatorService.registerOperators(argv[1], new FileInputStream(argv[1]), null);
            }
            catch (IOException e) {
                LogService.getGlobal().log("Cannot read 'operators.xml'.", 6);
            }
            File file = new File(argv[4]);
            LogService.getGlobal().log("Generating class documentation to '" + file + "'.", 2);
            PrintWriter out = new PrintWriter(new FileWriter(file));
            DocumentationGenerator docGen = new DocumentationGenerator(opDocGen);
            boolean generateSubgroups = false;
            if (argv.length == 6 && argv[5].equals("true")) {
                generateSubgroups = true;
            }
            docGen.getRootDoc(new File(argv[2]), argv[3]);
            docGen.generateAll(new PrintWriter(new FileWriter(file)), generateSubgroups);
            out.close();
        } else {
            LogService.getGlobal().log("usage: java com.rapidminer.doc.DocumentationGenerator or" + Tools.getLineSeparator() + "       java com.rapidminer.doc.DocumentationGenerator operatordesc srcdir subpackages outputfile [generate subgroups (true/false)]", 5);
        }
    }
}

