/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.doc;

import com.rapidminer.doc.CiteTaglet;
import com.rapidminer.doc.MathTaglet;
import com.rapidminer.doc.OperatorDocGenerator;
import com.rapidminer.doc.RefTaglet;
import com.rapidminer.doc.TexTaglet;
import com.rapidminer.doc.XMLExampleTaglet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCapability;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.Value;
import com.rapidminer.operator.learner.Learner;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.OperatorService;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.Tag;
import com.sun.tools.doclets.Taglet;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractOperatorDocGenerator
implements OperatorDocGenerator {
    public static final int OPERATOR = 0;
    public static final int OPERATOR_NAME = 1;
    public static final int GROUP_NAME = 2;
    public static final int PARAMETER_LIST = 3;
    public static final int PARAMETER_ITEM = 4;
    public static final int PARAMETER_NAME_REQ = 5;
    public static final int PARAMETER_NAME_OPT = 6;
    public static final int PARAMETER_DESCRIPTION = 7;
    public static final int SHORT_DESCRIPTION = 8;
    public static final int OPERATOR_DESCRIPTION = 9;
    public static final int INPUT_CLASSES_LIST = 10;
    public static final int OUTPUT_CLASSES_LIST = 11;
    public static final int IO_CLASS = 12;
    public static final int INNER_OPERATOR = 13;
    public static final int VALUE_LIST = 14;
    public static final int VALUE_ITEM = 15;
    public static final int VALUE_NAME = 16;
    public static final int VALUE_DESCRIPTION = 17;
    public static final int INDEX_ENTRY = 18;
    public static final int REFERENCE_SECTION = 19;
    public static final int REFERENCE_ENTRY = 20;
    public static final int TECHNICAL_INFORMATION = 21;
    public static final int DEPRECATION_INFO = 22;
    public static final int LEARNER_CAPABILITIES = 23;
    private Map<String, Taglet> tagletMap = new HashMap<String, Taglet>();

    public abstract String transformHTMLJavadocComment(String var1, Class var2, String var3);

    public abstract String escape(String var1);

    public abstract String getOpenTag(int var1);

    public abstract String getCloseTag(int var1);

    public abstract String marginIcon(String var1);

    public AbstractOperatorDocGenerator() {
        CiteTaglet.register(this.tagletMap);
        MathTaglet.register(this.tagletMap);
        RefTaglet.register(this.tagletMap);
        XMLExampleTaglet.register(this.tagletMap);
    }

    @Override
    public void generateDoc(Operator op, RootDoc rootDoc, PrintWriter out) {
        int i;
        Collection<Value> values;
        List<ParameterType> parameters;
        Class<?>[] output;
        Class<?>[] input;
        int i2;
        ClassDoc opDoc = rootDoc.classNamed(op.getClass().getName());
        out.println(this.getOpenTag(0));
        this.printTags(out, op.getOperatorDescription().getName(), 1);
        out.println();
        if (op.getOperatorDescription().getIconName() != null) {
            out.println(this.marginIcon(op.getOperatorDescription().getIconName()));
        }
        if (op.getOperatorDescription().getGroup() != null && op.getOperatorDescription().getGroup().trim().length() > 0) {
            this.printTags(out, op.getOperatorDescription().getGroup(), 2);
        }
        if (opDoc != null) {
            Tag[] indexTags = opDoc.tags("rapidminer.index");
            for (i2 = 0; i2 < indexTags.length; ++i2) {
                this.printTags(out, indexTags[i2].text(), 18);
            }
        }
        if (op.getOperatorDescription().getDeprecationInfo() != null) {
            this.printTags(out, op.getOperatorDescription().getDeprecationInfo(), 22);
            out.println();
        }
        if ((input = op.getInputClasses()) != null && input.length > 0) {
            out.println(this.getOpenTag(10));
            for (i2 = 0; i2 < input.length; ++i2) {
                this.printTags(out, input[i2].getSimpleName(), 12);
                out.println();
            }
            out.println(this.getCloseTag(10));
        }
        if ((output = op.getOutputClasses()) != null && output.length > 0) {
            out.println(this.getOpenTag(11));
            for (int i3 = 0; i3 < output.length; ++i3) {
                this.printTags(out, output[i3].getSimpleName(), 12);
                out.println();
            }
            out.println(this.getCloseTag(11));
        }
        if ((parameters = op.getParameterTypes()).size() > 0) {
            out.println(this.getOpenTag(3));
            for (ParameterType type : parameters) {
                out.print(this.getOpenTag(4));
                if (type.isOptional()) {
                    this.printTags(out, type.getKey(), 6);
                } else {
                    this.printTags(out, type.getKey(), 5);
                }
                if (type instanceof ParameterTypeCategory || type instanceof ParameterTypeStringCategory) {
                    this.printTags(out, type.getDescription(), 7);
                } else {
                    this.printTags(out, type.getDescription() + (type.showRange() && type.getRange() != null ? " (" + type.getRange() + ")" : ""), 7);
                }
                out.println(this.getCloseTag(4));
            }
            out.println(this.getCloseTag(3));
        }
        if ((values = op.getValues()).size() > 0) {
            out.println(this.getOpenTag(14));
            for (Value value : values) {
                out.print(this.getOpenTag(15));
                this.printTags(out, value.getKey(), 16);
                this.printTags(out, value.getDescription(), 17);
                out.println(this.getCloseTag(15));
            }
            out.println(this.getCloseTag(14));
        }
        if (op instanceof Learner) {
            String result;
            Learner learner = (Learner)((Object)op);
            StringBuffer learnerCapabilities = new StringBuffer();
            boolean first = true;
            for (OperatorCapability capability : OperatorCapability.values()) {
                try {
                    if (!learner.supportsCapability(capability)) continue;
                    if (!first) {
                        learnerCapabilities.append(", ");
                    }
                    learnerCapabilities.append(capability.getDescription());
                    first = false;
                }
                catch (Exception e) {
                    break;
                }
            }
            if ((result = learnerCapabilities.toString()).length() > 0) {
                out.print(this.getOpenTag(23));
                out.print(result);
                out.print(this.getCloseTag(23));
            }
        }
        StringBuffer classComment = new StringBuffer();
        if (opDoc != null) {
            Tag[] inlineTags = opDoc.inlineTags();
            for (i = 0; i < inlineTags.length; ++i) {
                if (inlineTags[i] instanceof SeeTag) {
                    try {
                        Class<?> referencedClass = Class.forName(((SeeTag)inlineTags[i]).referencedClass().qualifiedName());
                        if (Operator.class.isAssignableFrom(referencedClass)) {
                            if (Modifier.isAbstract(referencedClass.getModifiers())) {
                                classComment.append("\\op{" + referencedClass.getSimpleName() + "}");
                                continue;
                            }
                            try {
                                Object refOp = OperatorService.createOperator(referencedClass);
                                classComment.append("\\refop{" + ((Operator)refOp).getOperatorDescription().getName() + "}");
                            }
                            catch (OperatorCreationException e) {
                                classComment.append("\\op{" + referencedClass.getSimpleName() + "}");
                            }
                            continue;
                        }
                        if (IOObject.class.isAssignableFrom(referencedClass)) {
                            classComment.append("\\ioobj{" + referencedClass.getSimpleName() + "}");
                            continue;
                        }
                        classComment.append("\\java{" + referencedClass.getSimpleName() + "}");
                    }
                    catch (Throwable e) {
                        LogService.getGlobal().log("In see tag '" + inlineTags[i] + "' of " + op.getClass().getName() + ": " + e, 6);
                    }
                    continue;
                }
                Taglet taglet = this.tagletMap.get(inlineTags[i].name().substring(1));
                if (taglet instanceof TexTaglet) {
                    classComment.append(((TexTaglet)taglet).toTex(inlineTags[i]));
                    continue;
                }
                classComment.append(this.escape(inlineTags[i].text()));
            }
        }
        out.println(this.getOpenTag(8) + this.transformHTMLJavadocComment(op.getOperatorDescription().getShortDescription(), op.getClass(), op.getOperatorDescription().getName()) + this.getCloseTag(8));
        out.println();
        out.print(this.getOpenTag(9) + this.transformHTMLJavadocComment(classComment.toString(), op.getClass(), op.getOperatorDescription().getName()) + this.getCloseTag(9));
        out.println();
        if (opDoc != null) {
            Tag[] citeTags = opDoc.tags("rapidminer.cite");
            if (citeTags.length > 0) {
                out.println(this.getOpenTag(19));
            }
            for (i = 0; i < citeTags.length; ++i) {
                this.printTags(out, citeTags[i].text(), 20);
            }
        }
        out.println(this.getCloseTag(0));
    }

    private void printTags(PrintWriter out, String text, int tagNo) {
        out.print(this.getOpenTag(tagNo) + this.escape(text) + this.getCloseTag(tagNo));
    }
}

