/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.datatable;

import com.rapidminer.datatable.AbstractDataTable;
import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.tools.Tools;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class SimpleDataTable
extends AbstractDataTable
implements Serializable {
    private static final long serialVersionUID = 4459570725439894361L;
    private List<DataTableRow> data = new ArrayList<DataTableRow>();
    private String[] columns;
    private double[] weights;
    private boolean[] specialColumns;
    private Map<Integer, Map<Integer, String>> index2StringMap = new HashMap<Integer, Map<Integer, String>>();
    private Map<Integer, Map<String, Integer>> string2IndexMap = new HashMap<Integer, Map<String, Integer>>();
    private int[] currentIndices;

    public SimpleDataTable(String name, String[] columns) {
        this(name, columns, null);
    }

    public SimpleDataTable(String name, String[] columns, double[] weights) {
        super(name);
        int i;
        this.columns = columns;
        this.weights = weights;
        this.specialColumns = new boolean[columns.length];
        for (i = 0; i < this.specialColumns.length; ++i) {
            this.specialColumns[i] = false;
        }
        this.currentIndices = new int[columns.length];
        for (i = 0; i < this.currentIndices.length; ++i) {
            this.currentIndices[i] = 0;
        }
    }

    private SimpleDataTable(SimpleDataTable simpleDataTable) {
        super(simpleDataTable.getName());
        HashMap<Object, Object> newIndexMap;
        Map<Object, Object> indexMap;
        Integer key;
        int i;
        this.columns = null;
        if (simpleDataTable.columns != null) {
            this.columns = new String[simpleDataTable.columns.length];
            for (i = 0; i < simpleDataTable.columns.length; ++i) {
                this.columns[i] = simpleDataTable.columns[i];
            }
        }
        this.weights = null;
        if (simpleDataTable.weights != null) {
            this.weights = new double[simpleDataTable.weights.length];
            for (i = 0; i < simpleDataTable.weights.length; ++i) {
                this.weights[i] = simpleDataTable.weights[i];
            }
        }
        this.specialColumns = null;
        if (simpleDataTable.specialColumns != null) {
            this.specialColumns = new boolean[simpleDataTable.specialColumns.length];
            for (i = 0; i < simpleDataTable.specialColumns.length; ++i) {
                this.specialColumns[i] = simpleDataTable.specialColumns[i];
            }
        }
        this.currentIndices = new int[simpleDataTable.currentIndices.length];
        for (i = 0; i < this.currentIndices.length; ++i) {
            this.currentIndices[i] = simpleDataTable.currentIndices[i];
        }
        this.index2StringMap = new HashMap<Integer, Map<Integer, String>>();
        for (Map.Entry<Integer, Map<Integer, String>> entry : simpleDataTable.index2StringMap.entrySet()) {
            key = entry.getKey();
            indexMap = entry.getValue();
            newIndexMap = new HashMap<Object, Object>();
            for (Map.Entry<Integer, String> entry2 : indexMap.entrySet()) {
                newIndexMap.put(entry2.getKey(), entry2.getValue());
            }
            this.index2StringMap.put(key, newIndexMap);
        }
        this.string2IndexMap = new HashMap<Integer, Map<String, Integer>>();
        for (Map.Entry<Integer, Map<Object, Object>> entry : simpleDataTable.string2IndexMap.entrySet()) {
            key = entry.getKey();
            indexMap = entry.getValue();
            newIndexMap = new HashMap();
            for (Map.Entry<Object, Object> entry3 : indexMap.entrySet()) {
                newIndexMap.put(entry3.getKey(), entry3.getValue());
            }
            this.string2IndexMap.put(key, newIndexMap);
        }
    }

    @Override
    public int getNumberOfSpecialColumns() {
        int counter = 0;
        for (boolean b : this.specialColumns) {
            if (!b) continue;
            ++counter;
        }
        return counter;
    }

    @Override
    public boolean isSpecial(int index) {
        return this.specialColumns[index];
    }

    public void setSpecial(int index, boolean special) {
        this.specialColumns[index] = special;
    }

    @Override
    public boolean isNominal(int column) {
        return this.index2StringMap.get(column) != null;
    }

    @Override
    public boolean isDate(int index) {
        return false;
    }

    @Override
    public boolean isTime(int index) {
        return false;
    }

    @Override
    public boolean isDateTime(int index) {
        return false;
    }

    @Override
    public boolean isNumerical(int index) {
        return !this.isNominal(index);
    }

    @Override
    public String mapIndex(int column, int index) {
        Map<Integer, String> columnIndexMap = this.index2StringMap.get(column);
        return columnIndexMap.get(index);
    }

    @Override
    public int mapString(int column, String value) {
        Map<String, Integer> columnValueMap = this.string2IndexMap.get(column);
        if (columnValueMap == null) {
            columnValueMap = new HashMap<String, Integer>();
            columnValueMap.put(value, this.currentIndices[column]);
            this.string2IndexMap.put(column, columnValueMap);
            HashMap<Integer, String> columnIndexMap = new HashMap<Integer, String>();
            columnIndexMap.put(this.currentIndices[column], value);
            this.index2StringMap.put(column, columnIndexMap);
            int returnValue = this.currentIndices[column];
            int n = column;
            this.currentIndices[n] = this.currentIndices[n] + 1;
            return returnValue;
        }
        Integer result = columnValueMap.get(value);
        if (result != null) {
            return result;
        }
        int newIndex = this.currentIndices[column];
        columnValueMap.put(value, newIndex);
        Map<Integer, String> columnIndexMap = this.index2StringMap.get(column);
        columnIndexMap.put(newIndex, value);
        int n = column;
        this.currentIndices[n] = this.currentIndices[n] + 1;
        return newIndex;
    }

    @Override
    public int getNumberOfValues(int column) {
        return this.index2StringMap.get(column).size();
    }

    public void cleanMappingTables() {
        HashMap allValues = new HashMap();
        for (Map.Entry<Integer, Map<String, Integer>> entry : this.string2IndexMap.entrySet()) {
            Integer key = entry.getKey();
            HashSet<String> columnValues = new HashSet<String>();
            for (String current : entry.getValue().keySet()) {
                columnValues.add(current);
            }
            allValues.put(key, columnValues);
        }
        for (DataTableRow row : this) {
            for (int i = 0; i < this.getNumberOfColumns(); ++i) {
                if (!this.isNominal(i)) continue;
                String currentValue = this.getValueAsString(row, i);
                ((Set)allValues.get(i)).remove(currentValue);
            }
        }
        for (int i = 0; i < this.getNumberOfColumns(); ++i) {
            Set toDelete = (Set)allValues.get(i);
            if (toDelete == null) continue;
            Map<String, Integer> string2Index = this.string2IndexMap.get(i);
            Map<Integer, String> index2String = this.index2StringMap.get(i);
            for (String current : toDelete) {
                int oldIndex = string2Index.get(current);
                index2String.remove(oldIndex);
                string2Index.remove(current);
            }
        }
    }

    @Override
    public boolean isSupportingColumnWeights() {
        return this.weights != null;
    }

    @Override
    public double getColumnWeight(int column) {
        if (this.weights == null) {
            return Double.NaN;
        }
        return this.weights[column];
    }

    @Override
    public String getColumnName(int i) {
        return this.columns[i];
    }

    @Override
    public int getColumnIndex(String name) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i].equals(name)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getNumberOfColumns() {
        return this.columns.length;
    }

    @Override
    public String[] getColumnNames() {
        return this.columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void add(DataTableRow row) {
        List<DataTableRow> list = this.data;
        synchronized (list) {
            this.data.add(row);
            this.fireEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void remove(DataTableRow row) {
        List<DataTableRow> list = this.data;
        synchronized (list) {
            this.data.remove(row);
            this.fireEvent();
        }
    }

    @Override
    public DataTableRow getRow(int index) {
        return this.data.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Iterator<DataTableRow> iterator() {
        Iterator<DataTableRow> i = null;
        List<DataTableRow> list = this.data;
        synchronized (list) {
            i = this.data.iterator();
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfRows() {
        int result = 0;
        List<DataTableRow> list = this.data;
        synchronized (list) {
            result = this.data.size();
        }
        return result;
    }

    public void clear() {
        this.data.clear();
        this.fireEvent();
    }

    @Override
    public synchronized DataTable sample(int newSize) {
        if (this.getNumberOfRows() <= newSize) {
            return this;
        }
        SimpleDataTable result = new SimpleDataTable(this);
        Random random = new Random();
        ArrayList<Integer> indices = new ArrayList<Integer>(this.getNumberOfRows());
        for (int i = 0; i < this.getNumberOfRows(); ++i) {
            indices.add(i);
        }
        while (result.getNumberOfRows() < newSize) {
            int index = random.nextInt(indices.size());
            result.add(this.data.get((Integer)indices.remove(index)));
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (DataTableRow row : this) {
            for (int i = 0; i < this.getNumberOfColumns(); ++i) {
                if (i != 0) {
                    result.append(", ");
                }
                result.append(row.getValue(i));
            }
            result.append(Tools.getLineSeparator());
        }
        return result.toString();
    }
}

