/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.datatable;

import com.rapidminer.datatable.DataTableFilterCondition;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.tools.math.container.Range;
import java.util.LinkedHashMap;
import java.util.Map;

public class RegionFilterCondition
implements DataTableFilterCondition {
    private Region region;

    public RegionFilterCondition(Region region) {
        this.region = region;
    }

    @Override
    public boolean keepRow(DataTableRow row) {
        return this.region.containsRow(row);
    }

    public static final Region createRegion() {
        return new Region();
    }

    public static final class Region {
        Map<Integer, Range> delimiters = new LinkedHashMap<Integer, Range>();

        public boolean addRestrictingRange(int dimension, Range range) {
            Range existing = this.delimiters.get(dimension);
            if (existing == null) {
                this.delimiters.put(dimension, range);
                return true;
            }
            if (existing.contains(range) && !existing.equals(range)) {
                this.delimiters.put(dimension, range);
                return true;
            }
            return false;
        }

        public boolean containsRow(DataTableRow row) {
            for (Map.Entry<Integer, Range> pair : this.delimiters.entrySet()) {
                if (pair.getValue().contains(row.getValue(pair.getKey()))) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object arg) {
            if (arg instanceof Region) {
                Region region = (Region)arg;
                boolean equal = region.delimiters.size() == this.delimiters.size();
                for (Integer key : this.delimiters.keySet()) {
                    if (!(equal &= this.delimiters.get(key).equals(region.delimiters.get(key)))) break;
                }
                return equal;
            }
            return false;
        }
    }
}

