/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.datatable;

import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.datatable.PairwiseMatrix2DataTableRowWrapper;
import com.rapidminer.operator.visualization.dependencies.NumericalMatrix;
import java.util.Iterator;

public class PairwiseMatrix2DataTableRowIterator
implements Iterator<DataTableRow> {
    private NumericalMatrix matrix;
    private int firstAttribute;
    private int secondAttribute;

    public PairwiseMatrix2DataTableRowIterator(NumericalMatrix matrix) {
        this.matrix = matrix;
        this.firstAttribute = 0;
        this.secondAttribute = matrix.isSymmetrical() ? 1 : 0;
    }

    @Override
    public boolean hasNext() {
        return this.firstAttribute < this.matrix.getNumberOfRows() && this.secondAttribute < this.matrix.getNumberOfColumns();
    }

    @Override
    public DataTableRow next() {
        PairwiseMatrix2DataTableRowWrapper row = new PairwiseMatrix2DataTableRowWrapper(this.matrix, this.firstAttribute, this.secondAttribute);
        if (this.matrix.isSymmetrical()) {
            ++this.secondAttribute;
            if (this.secondAttribute >= this.matrix.getNumberOfColumns()) {
                ++this.firstAttribute;
                this.secondAttribute = this.firstAttribute + 1;
            }
        } else {
            ++this.secondAttribute;
            if (this.secondAttribute >= this.matrix.getNumberOfColumns()) {
                this.secondAttribute = 0;
                ++this.firstAttribute;
            }
        }
        return row;
    }

    @Override
    public void remove() {
        throw new RuntimeException("PairwiseCorrelation2DataTableRowIterator: removing rows is not supported!");
    }
}

