/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.datatable;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableListener;
import com.rapidminer.datatable.DataTableRow;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.TreeSet;

public class GnuPlotDataTableHandler
implements DataTableListener {
    private static final Comparator<double[]> ROW_COMPARATOR = new Comparator<double[]>(){

        @Override
        public int compare(double[] row1, double[] row2) {
            for (int i = 0; i < row1.length; ++i) {
                if (row1[i] < row2[i]) {
                    return -1;
                }
                if (!(row1[i] > row2[i])) continue;
                return 1;
            }
            return 0;
        }
    };
    private DataTable table;

    public GnuPlotDataTableHandler(DataTable table) {
        this.table = table;
        this.table.addDataTableListener(this);
    }

    @Override
    public void dataTableUpdated(DataTable table) {
        this.table = table;
    }

    public void writeGNUPlot(PrintStream out, int x, int y, int[] z, String linetype, String additionalCommands, String terminal) {
        int i;
        this.writeGNUPlotHeader(out, this.table.getColumnName(x), y != -1 ? this.table.getColumnName(y) : this.table.getColumnName(z[0]), this.table.getColumnName(z[0]), additionalCommands, terminal);
        if (y != -1) {
            out.print("splot ");
        } else {
            out.print("plot ");
        }
        for (i = 0; i < z.length; ++i) {
            if (i > 0) {
                out.print(", ");
            }
            out.print("'-' title \"" + this.table.getColumnName(z[i]) + "\" with " + linetype);
        }
        out.println();
        for (i = 0; i < z.length; ++i) {
            if (y != -1) {
                this.write3DGNUPlotData(out, x, y, z[i]);
            } else {
                this.write2DGNUPlotData(out, x, z[i]);
            }
            out.println("e");
        }
    }

    private void writeGNUPlotHeader(PrintStream out, String xAxis, String yAxis, String zAxis, String additionalCommands, String terminal) {
        out.println("#!gnuplot");
        out.println("# Generated by " + this.getClass() + " on " + DateFormat.getDateTimeInstance().format(new Date()));
        if (xAxis != null) {
            out.println("set xlabel \"" + xAxis + "\"");
        }
        if (yAxis != null) {
            out.println("set ylabel \"" + yAxis + "\"");
        }
        if (zAxis != null) {
            out.println("set zlabel \"" + zAxis + "\"");
        }
        if (additionalCommands != null) {
            out.println(additionalCommands);
        }
        if (terminal != null) {
            out.println("set terminal " + terminal);
        }
    }

    private void write2DGNUPlotData(PrintStream out, int x, int y) {
        TreeSet<double[]> plot = new TreeSet<double[]>(ROW_COMPARATOR);
        for (DataTableRow row : this.table) {
            plot.add(new double[]{row.getValue(x), row.getValue(y)});
        }
        for (double[] row : plot) {
            out.println(row[0] + "\t" + row[1]);
        }
    }

    private void write3DGNUPlotData(PrintStream out, int x, int y, int z) {
        TreeSet<double[]> plot = new TreeSet<double[]>(ROW_COMPARATOR);
        for (DataTableRow row : this.table) {
            plot.add(new double[]{row.getValue(x), row.getValue(y), row.getValue(z)});
        }
        double oldX = Double.NaN;
        for (double[] row : plot) {
            if (!Double.isNaN(oldX) && row[0] != oldX) {
                out.println();
            }
            out.println(row[0] + "\t" + row[1] + "\t" + row[2]);
            oldX = row[0];
        }
    }
}

