/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.datatable;

import com.rapidminer.datatable.AbstractDataTable;
import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableFilterCondition;
import com.rapidminer.datatable.DataTableListener;
import com.rapidminer.datatable.DataTableRow;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class FilteredDataTable
extends AbstractDataTable
implements DataTableListener {
    private List<DataTableFilteredListener> listeners = new LinkedList<DataTableFilteredListener>();
    private DataTable parentTable;
    private int[] selectedIndices;
    private int numberOfSelectedRows;
    private ArrayList<DataTableFilterCondition> conditionStack = new ArrayList();

    public FilteredDataTable(DataTable parentDataTable) {
        super(parentDataTable.getName());
        this.parentTable = parentDataTable;
        this.selectedIndices = new int[this.parentTable.getNumberOfRows()];
        for (int i = 0; i < this.selectedIndices.length; ++i) {
            this.selectedIndices[i] = i;
        }
        this.numberOfSelectedRows = this.parentTable.getNumberOfRows();
        this.parentTable.addDataTableListener(this);
    }

    @Override
    public Iterator<DataTableRow> iterator() {
        return new Iterator<DataTableRow>(){
            int nextRow = 0;

            @Override
            public boolean hasNext() {
                return this.nextRow < FilteredDataTable.this.getNumberOfRows();
            }

            @Override
            public DataTableRow next() {
                DataTableRow row = FilteredDataTable.this.getRow(this.nextRow);
                ++this.nextRow;
                return row;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove() not suppported by FilterDataTable");
            }
        };
    }

    @Override
    public DataTableRow getRow(int index) {
        if (index < this.numberOfSelectedRows) {
            return this.parentTable.getRow(this.selectedIndices[index]);
        }
        throw new ArrayIndexOutOfBoundsException("Index exceeds filtered range: " + index);
    }

    @Override
    public int getNumberOfRows() {
        return this.numberOfSelectedRows;
    }

    public void addCondition(DataTableFilterCondition condtion) {
        this.conditionStack.add(condtion);
        this.updateSelection();
    }

    public void removeCondition() {
        if (this.conditionStack.size() > 0) {
            this.conditionStack.remove(this.conditionStack.size() - 1);
            this.updateSelection();
            if (this.conditionStack.size() == 0) {
                this.selectedIndices = new int[this.parentTable.getNumberOfRows()];
                for (int i = 0; i < this.selectedIndices.length; ++i) {
                    this.selectedIndices[i] = i;
                }
                this.numberOfSelectedRows = this.parentTable.getNumberOfRows();
            }
        }
    }

    private void updateSelection() {
        int parentRowIndex = 0;
        this.numberOfSelectedRows = 0;
        for (DataTableRow row : this.parentTable) {
            boolean keep = true;
            for (int conditionIndex = this.conditionStack.size() - 1; conditionIndex >= 0 && keep; keep &= this.conditionStack.get(conditionIndex).keepRow(row), --conditionIndex) {
            }
            if (keep) {
                this.selectedIndices[this.numberOfSelectedRows] = parentRowIndex;
                ++this.numberOfSelectedRows;
            }
            ++parentRowIndex;
        }
        this.informDataTableFilteredListener();
    }

    public void addDataTableFilteredListener(DataTableFilteredListener listener) {
        this.listeners.add(listener);
    }

    public void removeDataTableFilteredListewner(DataTableFilteredListener listener) {
        this.listeners.remove(listener);
    }

    private void informDataTableFilteredListener() {
        for (DataTableFilteredListener listener : this.listeners) {
            listener.informDataTableChange(this);
        }
    }

    @Override
    public void add(DataTableRow row) {
        this.parentTable.add(row);
    }

    @Override
    public int getColumnIndex(String name) {
        return this.parentTable.getColumnIndex(name);
    }

    @Override
    public String getColumnName(int i) {
        return this.parentTable.getColumnName(i);
    }

    @Override
    public double getColumnWeight(int i) {
        return this.parentTable.getColumnWeight(i);
    }

    @Override
    public int getNumberOfColumns() {
        return this.parentTable.getNumberOfColumns();
    }

    @Override
    public int getNumberOfSpecialColumns() {
        return this.parentTable.getNumberOfSpecialColumns();
    }

    @Override
    public int getNumberOfValues(int column) {
        return this.parentTable.getNumberOfValues(column);
    }

    @Override
    public boolean isDate(int index) {
        return this.parentTable.isDate(index);
    }

    @Override
    public boolean isDateTime(int index) {
        return this.parentTable.isDateTime(index);
    }

    @Override
    public boolean isNominal(int index) {
        return this.parentTable.isNominal(index);
    }

    @Override
    public boolean isNumerical(int index) {
        return this.parentTable.isNumerical(index);
    }

    @Override
    public boolean isSpecial(int column) {
        return this.parentTable.isSpecial(column);
    }

    @Override
    public boolean isSupportingColumnWeights() {
        return this.parentTable.isSupportingColumnWeights();
    }

    @Override
    public boolean isTime(int index) {
        return this.parentTable.isTime(index);
    }

    @Override
    public String mapIndex(int column, int index) {
        return this.parentTable.mapIndex(column, index);
    }

    @Override
    public int mapString(int column, String value) {
        return this.parentTable.mapString(column, value);
    }

    @Override
    public DataTable sample(int newSize) {
        return this;
    }

    @Override
    public void dataTableUpdated(DataTable source) {
        this.fireEvent();
    }

    public static interface DataTableFilteredListener {
        public void informDataTableChange(DataTable var1);
    }
}

