/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.datatable;

import com.rapidminer.datatable.AbstractDataTable;
import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.datatable.PairwiseMatrix2DataTableRowIterator;
import com.rapidminer.datatable.PairwiseMatrix2DataTableRowWrapper;
import com.rapidminer.operator.visualization.dependencies.NumericalMatrix;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataTablePairwiseMatrixExtractionAdapter
extends AbstractDataTable {
    private NumericalMatrix matrix;
    private String[] rowNames;
    private Map<String, Integer> rowName2IndexMap = new HashMap<String, Integer>();
    private String[] columnNames;
    private Map<String, Integer> columnName2IndexMap = new HashMap<String, Integer>();
    private String[] tableColumnNames;

    public DataTablePairwiseMatrixExtractionAdapter(NumericalMatrix matrix, String[] rowNames, String[] columnNames, String[] tableColumnNames) {
        super("Pairwise Correlation Table");
        int i;
        this.matrix = matrix;
        this.rowNames = rowNames;
        for (i = 0; i < this.rowNames.length; ++i) {
            this.rowName2IndexMap.put(this.rowNames[i], i);
        }
        this.columnNames = columnNames;
        for (i = 0; i < this.columnNames.length; ++i) {
            this.columnName2IndexMap.put(this.columnNames[i], i);
        }
        this.tableColumnNames = tableColumnNames;
        if (this.tableColumnNames == null || this.tableColumnNames.length != 3) {
            throw new RuntimeException("Cannot create pairwise matrix extraction data table with other than 3 table column names.");
        }
    }

    @Override
    public int getNumberOfSpecialColumns() {
        return 0;
    }

    @Override
    public boolean isSpecial(int index) {
        return false;
    }

    @Override
    public boolean isNominal(int index) {
        return index <= 1;
    }

    @Override
    public boolean isDate(int index) {
        return false;
    }

    @Override
    public boolean isTime(int index) {
        return false;
    }

    @Override
    public boolean isDateTime(int index) {
        return false;
    }

    @Override
    public boolean isNumerical(int index) {
        return index > 1;
    }

    @Override
    public String mapIndex(int column, int value) {
        if (column == 0) {
            return this.rowNames[value];
        }
        if (column == 1) {
            return this.columnNames[value];
        }
        return "?";
    }

    @Override
    public int mapString(int column, String value) {
        if (column == 0) {
            Integer result = this.rowName2IndexMap.get(value);
            if (result == null) {
                return -1;
            }
            return result;
        }
        if (column == 1) {
            Integer result = this.columnName2IndexMap.get(value);
            if (result == null) {
                return -1;
            }
            return result;
        }
        return -1;
    }

    @Override
    public int getNumberOfValues(int column) {
        if (column == 0) {
            return this.rowNames.length;
        }
        if (column == 1) {
            return this.columnNames.length;
        }
        return -1;
    }

    @Override
    public String getColumnName(int i) {
        return this.tableColumnNames[i];
    }

    @Override
    public int getColumnIndex(String name) {
        for (int i = 0; i < this.tableColumnNames.length; ++i) {
            if (!this.tableColumnNames[i].equals(name)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isSupportingColumnWeights() {
        return false;
    }

    @Override
    public double getColumnWeight(int column) {
        return Double.NaN;
    }

    @Override
    public int getNumberOfColumns() {
        return this.tableColumnNames.length;
    }

    @Override
    public void add(DataTableRow row) {
        throw new RuntimeException("DataTablePairwiseCorrelationMatrixAdapter: adding new rows is not supported!");
    }

    @Override
    public DataTableRow getRow(int rowIndex) {
        if (this.matrix.isSymmetrical()) {
            int firstAttribute = 0;
            int secondAttribute = 1;
            for (int i = 0; i < rowIndex; ++i) {
                if (++secondAttribute < this.matrix.getNumberOfColumns()) continue;
                secondAttribute = ++firstAttribute + 1;
            }
            return new PairwiseMatrix2DataTableRowWrapper(this.matrix, firstAttribute, secondAttribute);
        }
        return new PairwiseMatrix2DataTableRowWrapper(this.matrix, rowIndex / this.matrix.getNumberOfColumns(), rowIndex % this.matrix.getNumberOfColumns());
    }

    @Override
    public Iterator<DataTableRow> iterator() {
        return new PairwiseMatrix2DataTableRowIterator(this.matrix);
    }

    @Override
    public int getNumberOfRows() {
        if (this.matrix.isSymmetrical()) {
            return (this.rowNames.length * this.rowNames.length - this.rowNames.length) / 2;
        }
        return this.matrix.getNumberOfRows() * this.matrix.getNumberOfColumns();
    }

    @Override
    public DataTable sample(int newSize) {
        return this;
    }
}

