/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.datatable;

import com.rapidminer.datatable.AbstractDataTable;
import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.datatable.KernelModelRow2DataTableRowWrapper;
import com.rapidminer.example.Attribute;
import com.rapidminer.operator.learner.functions.kernel.KernelModel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;

public class DataTableKernelModelAdapter
extends AbstractDataTable {
    private KernelModel kernelModel;
    private String[] attributeNames;
    private int[] sampleMapping = null;
    private Map<Integer, String> index2LabelMap = new HashMap<Integer, String>();
    private Map<String, Integer> label2IndexMap = new HashMap<String, Integer>();

    public DataTableKernelModelAdapter(KernelModel kernelModel) {
        super("Kernel Model Support Vectors");
        int i;
        this.kernelModel = kernelModel;
        int labelCounter = 0;
        if (this.kernelModel.isClassificationModel()) {
            for (i = 0; i < this.kernelModel.getNumberOfSupportVectors(); ++i) {
                String label = this.kernelModel.getClassificationLabel(i);
                if (this.label2IndexMap.get(label) != null) continue;
                this.label2IndexMap.put(label, labelCounter);
                this.index2LabelMap.put(labelCounter, label);
                ++labelCounter;
            }
        }
        this.attributeNames = new String[kernelModel.getTrainingHeader().getAttributes().size()];
        i = 0;
        for (Attribute attribute : kernelModel.getTrainingHeader().getAttributes()) {
            this.attributeNames[i] = attribute.getName();
            ++i;
        }
    }

    public DataTableKernelModelAdapter(DataTableKernelModelAdapter dataTableKernelModelAdapter) {
        super(dataTableKernelModelAdapter.getName());
        this.kernelModel = dataTableKernelModelAdapter.kernelModel;
        this.index2LabelMap = dataTableKernelModelAdapter.index2LabelMap;
        this.label2IndexMap = dataTableKernelModelAdapter.label2IndexMap;
        this.sampleMapping = null;
    }

    @Override
    public int getNumberOfSpecialColumns() {
        return 6;
    }

    @Override
    public boolean isSpecial(int index) {
        return index < 6;
    }

    @Override
    public boolean isNominal(int index) {
        if (index == 1) {
            return this.kernelModel.isClassificationModel();
        }
        return index == 5;
    }

    @Override
    public boolean isDate(int index) {
        return false;
    }

    @Override
    public boolean isTime(int index) {
        return false;
    }

    @Override
    public boolean isDateTime(int index) {
        return false;
    }

    @Override
    public boolean isNumerical(int index) {
        return !this.isNominal(index);
    }

    @Override
    public String mapIndex(int column, int value) {
        if (column == 1 && this.kernelModel.isClassificationModel()) {
            return this.index2LabelMap.get(value);
        }
        if (column == 5) {
            if (value == 0) {
                return "no support vector";
            }
            return "support vector";
        }
        return null;
    }

    @Override
    public int mapString(int column, String value) {
        if (column == 1 && this.kernelModel.isClassificationModel()) {
            return this.label2IndexMap.get(value);
        }
        if (column == 5) {
            if ("no support vector".equals(value)) {
                return 0;
            }
            return 1;
        }
        return -1;
    }

    @Override
    public int getNumberOfValues(int column) {
        if (column == 1 && this.kernelModel.isClassificationModel()) {
            return this.index2LabelMap.size();
        }
        if (column == 5) {
            return 2;
        }
        return -1;
    }

    @Override
    public String getColumnName(int i) {
        if (i < 6) {
            return KernelModelRow2DataTableRowWrapper.SPECIAL_COLUMN_NAMES[i];
        }
        int attributeIndex = i - 6;
        if (attributeIndex >= 0 && attributeIndex <= this.attributeNames.length) {
            return this.attributeNames[attributeIndex];
        }
        return "attribute" + (attributeIndex + 1);
    }

    @Override
    public int getColumnIndex(String name) {
        for (int i = 0; i < 6; ++i) {
            if (!KernelModelRow2DataTableRowWrapper.SPECIAL_COLUMN_NAMES[i].equals(name)) continue;
            return i;
        }
        if (name.startsWith("attribute")) {
            return Integer.parseInt(name.substring("attribute".length())) + 6 - 1;
        }
        return -1;
    }

    @Override
    public boolean isSupportingColumnWeights() {
        return false;
    }

    @Override
    public double getColumnWeight(int column) {
        return Double.NaN;
    }

    @Override
    public int getNumberOfColumns() {
        return this.kernelModel.getNumberOfAttributes() + 6;
    }

    @Override
    public int getNumberOfRows() {
        if (this.sampleMapping == null) {
            return this.kernelModel.getNumberOfSupportVectors();
        }
        return this.sampleMapping.length;
    }

    @Override
    public void add(DataTableRow row) {
        throw new RuntimeException("DataTableKernelModelAdapter: adding new rows is not supported!");
    }

    @Override
    public DataTableRow getRow(int index) {
        if (this.sampleMapping == null) {
            return new KernelModelRow2DataTableRowWrapper(this.kernelModel, this, index);
        }
        return new KernelModelRow2DataTableRowWrapper(this.kernelModel, this, this.sampleMapping[index]);
    }

    @Override
    public Iterator<DataTableRow> iterator() {
        return new KernelModelIterator(this);
    }

    @Override
    public DataTable sample(int newSize) {
        DataTableKernelModelAdapter result = new DataTableKernelModelAdapter(this);
        double ratio = (double)newSize / (double)this.getNumberOfRows();
        Random random = new Random(2001L);
        LinkedList<Integer> usedRows = new LinkedList<Integer>();
        for (int i = 0; i < this.getNumberOfRows(); ++i) {
            if (!(random.nextDouble() <= ratio)) continue;
            int index = i;
            if (this.sampleMapping != null) {
                index = this.sampleMapping[index];
            }
            usedRows.add(index);
        }
        int[] sampleMapping = new int[usedRows.size()];
        int counter = 0;
        Iterator i = usedRows.iterator();
        while (i.hasNext()) {
            sampleMapping[counter++] = (Integer)i.next();
        }
        result.sampleMapping = sampleMapping;
        return result;
    }

    private static class KernelModelIterator
    implements Iterator<DataTableRow> {
        private int counter = 0;
        private DataTableKernelModelAdapter adapter;

        public KernelModelIterator(DataTableKernelModelAdapter adapter) {
            this.adapter = adapter;
        }

        @Override
        public boolean hasNext() {
            return this.counter < this.adapter.getNumberOfRows();
        }

        @Override
        public DataTableRow next() {
            DataTableRow row = this.adapter.getRow(this.counter);
            ++this.counter;
            return row;
        }

        @Override
        public void remove() {
            throw new RuntimeException("DataTable.KernelModelIterator: remove not supported!");
        }
    }
}

